/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;

public final class Keyword
extends ASymbolic {
    public static final int MAX_CHARS = 128;
    public static final int MIN_CHARS = 1;

    private Keyword(StringShort name) {
        super(name);
    }

    @Override
    public AType getType() {
        return Types.KEYWORD;
    }

    public static Keyword create(String name) {
        if (name == null) {
            return null;
        }
        return Keyword.create(Strings.create(name));
    }

    public static Keyword create(Object o) {
        if (o instanceof Keyword) {
            Keyword k = (Keyword)o;
            return k;
        }
        if (o instanceof String) {
            String s = (String)o;
            return Keyword.create(s);
        }
        if (o instanceof AString) {
            AString s = (AString)o;
            return Keyword.create(s);
        }
        if (o instanceof ASymbolic) {
            ASymbolic s = (ASymbolic)o;
            return Keyword.create(s.getName());
        }
        return null;
    }

    public static Keyword intern(String name) {
        return Cells.intern(Keyword.create(name));
    }

    public static Keyword unsafeCreate(String rawName) {
        return Keyword.unsafeCreate((StringShort)Strings.create(rawName));
    }

    public static Keyword unsafeCreate(StringShort rawName) {
        return new Keyword(rawName);
    }

    public static Keyword create(AString name) {
        if (name == null) {
            return null;
        }
        if (!Keyword.validateName(name)) {
            return null;
        }
        return new Keyword((StringShort)name);
    }

    public static Keyword createChecked(AString aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + String.valueOf(aString));
        }
        return k;
    }

    public static Keyword createChecked(String aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + aString);
        }
        return k;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public static Keyword read(Blob blob, int offset) throws BadFormatException {
        int len = 0xFF & blob.byteAt(offset + 1);
        if (len > 128) {
            throw new BadFormatException("Keyword too long");
        }
        AString name = Format.readUTF8String(blob, offset + 2, len);
        Keyword kw = Keyword.create(name);
        if (kw == null) {
            throw new BadFormatException("Can't read keyword");
        }
        kw.attachEncoding(blob.slice(offset, offset + 2 + len));
        return kw;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 51;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = (byte)this.name.count();
        return this.name.writeRawData(bs, pos);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(':');
        bb.append(this.name);
        return bb.check(limit);
    }

    @Override
    public boolean equals(ACell other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Keyword)) {
            return false;
        }
        return this.name.equals(((Keyword)other).name);
    }

    public boolean equals(Keyword other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.name.equals(other.name);
    }

    @Override
    public int compareTo(ABlobLike<?> b) {
        if (b instanceof Keyword) {
            return this.compareTo((Keyword)b);
        }
        return -b.compareTo(this.toBlob());
    }

    @Override
    public int compareTo(Keyword k) {
        return this.name.compareTo(k.name.toBlob());
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!Keyword.validateName(this.name)) {
            throw new InvalidDataException("Invalid Keyword name: " + String.valueOf(this.name), this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public byte getTag() {
        return 51;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public AString toCVMString(long limit) {
        return Strings.COLON.append(this.name);
    }

    @Override
    public Keyword slice(long start, long end) {
        if (start >= end) {
            return null;
        }
        if (start == 0L && end == this.name.length) {
            return this;
        }
        return Keyword.create(this.name.slice(start, end));
    }
}

