/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.Hashing;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;

public class Hash
extends AArrayBlob {
    public static final int LENGTH = 32;
    public static final int HEX_LENGTH = 64;
    public static final Hash NULL_HASH = Hashing.sha3(new byte[]{0});
    public static final Hash TRUE_HASH = Hashing.sha3(new byte[]{-79});
    public static final Hash FALSE_HASH = Hashing.sha3(new byte[]{-80});
    public static final Hash EMPTY_HASH = Hashing.sha3(new byte[0]);

    private Hash(byte[] hashBytes, int offset) {
        super(hashBytes, offset, 32);
        this.memorySize = 0L;
    }

    private Hash(byte[] hashBytes) {
        super(hashBytes, 0, 32);
        this.memorySize = 0L;
    }

    public static Hash wrap(byte[] hashBytes) {
        return new Hash(hashBytes);
    }

    public static Hash wrap(ABlob a) {
        if (a == null) {
            return null;
        }
        if (a.count() != 32L) {
            return null;
        }
        if (a instanceof AArrayBlob) {
            return Hash.wrap((AArrayBlob)a);
        }
        return Hash.wrap(a.getBytes());
    }

    public static Hash wrap(AArrayBlob data) {
        if (data instanceof Hash) {
            return (Hash)data;
        }
        return Hash.wrap(data.getInternalArray(), data.getInternalOffset());
    }

    public static Hash wrap(AArrayBlob data, int pos) {
        if (pos == 0 && data instanceof Hash) {
            return (Hash)data;
        }
        if ((long)(pos + 32) > data.count()) {
            return null;
        }
        return Hash.wrap(data.getInternalArray(), Utils.checkedInt(data.getInternalOffset() + pos));
    }

    public static Hash wrap(byte[] hashBytes, int offset) {
        if (offset < 0 || offset + 32 > hashBytes.length) {
            throw new IllegalArgumentException(ErrorMessages.badRange(offset, offset + 32));
        }
        Hash h = new Hash(hashBytes, offset);
        if (offset >= 2 && hashBytes[offset - 1] == 32 && hashBytes[offset - 2] == 49) {
            h.attachEncoding(Blob.wrap(hashBytes, offset - 2, 34));
        }
        return h;
    }

    public int firstInt() {
        return Utils.readInt(this.store, this.offset);
    }

    public static Hash fromHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString);
        if (bs == null) {
            return null;
        }
        if (bs.length != 32) {
            return null;
        }
        return Hash.wrap(bs);
    }

    public static Hash parse(Object o) {
        return Hash.wrap(Blobs.parse(o));
    }

    public static Hash parse(String s) {
        return Hash.wrap(Blobs.parse(s));
    }

    public static Hash get(ACell value) {
        if (value == null) {
            return NULL_HASH;
        }
        return value.getHash();
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public Blob toCanonical() {
        return this.toFlatBlob();
    }

    @Override
    public int estimatedEncodingSize() {
        return 34;
    }

    @Override
    public int getEncodingLength() {
        return 34;
    }

    @Override
    public Blob getChunk(long i) {
        if (i != 0L) {
            throw new IndexOutOfBoundsException(ErrorMessages.badIndex(i));
        }
        return this.toFlatBlob();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count != 32L) {
            throw new InvalidDataException("Hash length must be 32 bytes = 256 bits", this);
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public final int compareTo(Hash b) {
        if (this == b) {
            return 0;
        }
        int c = Utils.compareByteArrays(this.store, this.offset, b.store, b.offset, 32);
        return c;
    }

    public boolean equals(Hash other) {
        if (other == this) {
            return true;
        }
        return Utils.arrayEquals(other.store, other.offset, this.store, this.offset, 32);
    }
}

