/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;

public class CodedValue
extends ACell {
    private final byte tag;
    private final Ref<ACell> codeRef;
    private final Ref<ACell> valueRef;

    private CodedValue(byte tag, Ref<ACell> code, Ref<ACell> value) {
        this.tag = tag;
        this.codeRef = code;
        this.valueRef = value;
    }

    public static CodedValue create(int tag, ACell code, ACell value) {
        return new CodedValue((byte)tag, Ref.get(code), Ref.get(value));
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public void validateStructure() throws InvalidDataException {
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public int getRefCount() {
        return 2;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        switch (i) {
            case 0: {
                return this.codeRef;
            }
            case 1: {
                return this.valueRef;
            }
        }
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public boolean equals(ACell a) {
        return Cells.equalsGeneric(this, a);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.codeRef.encode(bs, pos);
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    protected ACell toCanonical() {
        return this;
    }

    @Override
    public boolean isCVMValue() {
        return false;
    }

    @Override
    public CodedValue updateRefs(IRefFunction func) {
        Ref nc = func.apply(this.codeRef);
        Ref nv = func.apply(this.valueRef);
        if (nc == this.codeRef && nv == this.valueRef) {
            return this;
        }
        return new CodedValue(this.tag, nc, nv);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("#[");
        sb.append(this.getEncoding().toHexString());
        sb.append("]");
        return sb.check(limit);
    }

    public static CodedValue read(byte tag, Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<ACell> cref = Format.readRef(b, epos);
        epos = (int)((long)epos + cref.getEncodingLength());
        Ref<ACell> vref = Format.readRef(b, epos);
        epos = (int)((long)epos + vref.getEncodingLength());
        CodedValue result = new CodedValue(tag, cref, vref);
        if (tag == b.byteAtUnchecked(pos)) {
            result.attachEncoding(b.slice(pos, epos));
        }
        return result;
    }
}

