/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefDirect;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class AccountKey
extends AArrayBlob {
    public static final int LENGTH = 32;
    public static final int LENGTH_BITS = 256;
    public static final AccountKey NULL = null;

    private AccountKey(byte[] data, int offset, int length) {
        super(data, offset, length);
        this.memorySize = 0L;
        if (length != 32) {
            throw new IllegalArgumentException("AccountKey length must be 32 bytes");
        }
    }

    @Override
    protected <R extends ACell> Ref<R> createRef() {
        RefDirect<AccountKey> newRef;
        this.cachedRef = newRef = RefDirect.create(this, this.cachedHash(), 81);
        return newRef;
    }

    public static AccountKey wrap(byte[] data) {
        return new AccountKey(data, 0, data.length);
    }

    public static AccountKey wrap(byte[] data, int offset) {
        return new AccountKey(data, offset, 32);
    }

    public static AccountKey create(ABlob b) {
        if (b == null) {
            return null;
        }
        if (b.count() != 32L) {
            return null;
        }
        if (b instanceof AccountKey) {
            return (AccountKey)b;
        }
        if (b instanceof AArrayBlob) {
            AArrayBlob ab = (AArrayBlob)b;
            return new AccountKey(ab.getInternalArray(), ab.getInternalOffset(), 32);
        }
        return AccountKey.wrap(b.getBytes());
    }

    public static AccountKey dummy(String nonce) {
        int n = nonce.length();
        if (n == 0) {
            nonce = "FFFF0000";
        }
        if (n >= 16) {
            throw new IllegalArgumentException("Nonce too long for dummy address");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 64; i += n) {
            sb.append(nonce);
        }
        return AccountKey.fromHex(sb.substring(0, 64));
    }

    public boolean equals(AccountKey o) {
        if (o == this) {
            return true;
        }
        return Utils.arrayEquals(o.store, o.offset, this.store, this.offset, 32);
    }

    public static AccountKey fromHex(String hexString) {
        AccountKey result = AccountKey.fromHexOrNull(hexString);
        if (result == null) {
            throw new IllegalArgumentException("Invalid Address hex String [" + hexString + "]");
        }
        return result;
    }

    public static AccountKey parse(Object o) {
        if (o instanceof ACell) {
            if (o instanceof ABlob) {
                return AccountKey.create((ABlob)o);
            }
            o = RT.jvm((ACell)o);
        }
        if (o instanceof String) {
            return AccountKey.parse((String)o);
        }
        return null;
    }

    public static AccountKey parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("0x")) {
            s = s.substring(2);
        }
        return AccountKey.fromHexOrNull(s);
    }

    public static AccountKey fromHexOrNull(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString, 64);
        if (bs == null) {
            return null;
        }
        if (bs.length != 32) {
            return null;
        }
        return AccountKey.wrap(bs);
    }

    public static AccountKey fromHexOrNull(AString hexString) {
        if (hexString.count() != 64L) {
            return null;
        }
        return AccountKey.fromHexOrNull(hexString.toString());
    }

    public static AccountKey fromChecksumHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString, 64);
        Hash h = Blob.wrap(bs).getContentHash();
        for (int i = 0; i < 64; ++i) {
            boolean check;
            int dh = h.getHexDigit(i);
            char c = hexString.charAt(i);
            if (Character.isDigit(c) || (check = c >= 'a' ^ dh >= 8)) continue;
            throw new IllegalArgumentException("Bad checksum at position " + i + " in address " + hexString);
        }
        return AccountKey.wrap(bs);
    }

    public String toChecksumHex() {
        StringBuilder sb = new StringBuilder(64);
        Hash h = this.toFlatBlob().getContentHash();
        for (int i = 0; i < 64; ++i) {
            int dh = h.getHexDigit(i);
            int da = this.getHexDigit(i);
            if (da < 10) {
                sb.append((char)(48 + da));
                continue;
            }
            boolean up = dh >= 8;
            sb.append((char)((up ? 65 : 97) + da - 10));
        }
        return sb.toString();
    }

    public static AccountKey readRaw(ByteBuffer data) {
        byte[] buff = new byte[32];
        data.get(buff);
        return AccountKey.wrap(buff);
    }

    public static AccountKey readRaw(Blob b, int pos) {
        byte[] data = b.getInternalArray();
        int off = b.getInternalOffset();
        if ((long)(pos + 32) > b.count()) {
            throw new IndexOutOfBoundsException("wrapping AccountKey beyond bound");
        }
        return AccountKey.wrap(data, off + pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 35;
    }

    @Override
    public int getEncodingLength() {
        return 34;
    }

    @Override
    public Blob getChunk(long i) {
        if (i != 0L) {
            throw new IndexOutOfBoundsException(ErrorMessages.badIndex(i));
        }
        return this.toFlatBlob();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count != 32L) {
            throw new InvalidDataException("Address length must be 32  bytes = 256 bits", this);
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    protected long calcMemorySize() {
        return 0L;
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    protected Blob toCanonical() {
        return this.toFlatBlob();
    }
}

