/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.transactions;

import convex.core.cvm.AOp;
import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Context;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.Reader;

public class Invoke
extends ATransaction {
    protected ACell command;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.COMMAND};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    private static final long FORMAT_COUNT = FORMAT.count();

    protected Invoke(Address origin, long sequence, ACell command) {
        super((byte)-48, FORMAT, Vectors.create(origin, CVMLong.create(sequence), command));
        this.command = command;
    }

    protected Invoke(AVector<ACell> values) {
        super((byte)-48, FORMAT, values);
    }

    public static Invoke create(Address origin, long sequence, ACell command) {
        if (sequence < 0L) {
            throw new IllegalArgumentException("Illegal sequence number: " + sequence);
        }
        return new Invoke(origin, sequence, command);
    }

    public static Invoke create(Address address, long sequence, String command) {
        return Invoke.create(address, sequence, Reader.read(command));
    }

    public ACell getCommand() {
        if (this.command == null) {
            this.command = this.values.get(2);
        }
        return this.command;
    }

    public static Invoke read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != FORMAT_COUNT) {
            throw new BadFormatException("Wrong number of record values");
        }
        Invoke result = new Invoke(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public Context apply(Context context) {
        Context ctx = context;
        ACell cmd = this.getCommand();
        ctx = cmd instanceof AOp ? ctx.run((AOp)cmd) : ctx.run(cmd);
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 163;
    }

    @Override
    public Invoke withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Invoke.create(this.origin, newSequence, this.command);
    }

    @Override
    public Invoke withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Invoke.create(newAddress, this.sequence, this.command);
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.COMMAND.equals(key)) {
            return this.getCommand();
        }
        return super.get(key);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Invoke(this.values);
    }
}

