/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.Syntax;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.AObject;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;

public class Def<T extends ACell>
extends ACodedOp<T, ACell, AOp<T>> {
    private Def(Ref<ACell> key, Ref<AOp<T>> op) {
        super((byte)-51, key, op);
    }

    public static <T extends ACell> Def<T> create(ACell key, Ref<AOp<T>> op) {
        if (!Def.validKey(key)) {
            throw new IllegalArgumentException("Invalid Def key: " + String.valueOf(key));
        }
        return new Def<T>(key.getRef(), op);
    }

    public static <T extends ACell> Def<T> create(Syntax key, Ref<AOp<T>> op) {
        if (!Def.validKey(key)) {
            throw new IllegalArgumentException("Invalid Def key: " + String.valueOf(key));
        }
        return new Def<T>(key.getRef(), op);
    }

    public static <T extends ACell> Def<T> create(Syntax key, AOp<T> op) {
        return Def.create(key, op.getRef());
    }

    public static <T extends ACell> Def<T> create(Symbol key, AOp<T> op) {
        return new Def<T>(key.getRef(), op.getRef());
    }

    public static <T extends ACell> Def<T> create(ACell key, AOp<T> op) {
        return new Def<T>(key.getRef(), op.getRef());
    }

    public static <T extends ACell> Def<T> create(ACell key) {
        return new Def<T>(Ref.get(key), Ref.NULL_VALUE);
    }

    public static <T extends ACell> Def<T> create(String key, AOp<T> op) {
        return Def.create(Symbol.create(key), op);
    }

    @Override
    public Context execute(Context ctx) {
        Object result;
        AOp op = Ops.ensureOp(this.value.getValue());
        Object symbol = this.code.getValue();
        if (op != null) {
            if ((ctx = ctx.execute(op)).isExceptional()) {
                return ctx;
            }
            result = ctx.getResult();
        } else {
            result = ctx.getEnvironment().get((ACell)Syntax.unwrap(symbol));
        }
        if (symbol instanceof Syntax) {
            Syntax syn = (Syntax)symbol;
            ctx = ctx.defineWithSyntax(syn, (ACell)result);
        } else {
            ctx = ctx.define((Symbol)symbol, (ACell)result);
        }
        return ctx.withResult(100L, (ACell)result);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(def ");
        ((AObject)this.code.getValue()).print(sb, limit);
        sb.append(' ');
        if (!RT.print(sb, this.value.getValue(), limit)) {
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    public static <T extends ACell> Def<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        Ref<ACell> symbol = Format.readRef(b, epos);
        epos = (int)((long)epos + symbol.getEncodingLength());
        Ref<AOp<T>> ref = Format.readRef(b, epos);
        epos = (int)((long)epos + ref.getEncodingLength());
        Def<T> result = new Def<T>(symbol, ref);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    private static boolean validKey(ACell key) {
        if (key instanceof Symbol) {
            return true;
        }
        if (!(key instanceof Syntax)) {
            return false;
        }
        return ((Syntax)key).getValue() instanceof Symbol;
    }

    @Override
    protected Def<T> rebuild(Ref<ACell> newCode, Ref<AOp<T>> newValue) {
        if (this.code == newCode && this.value == newValue) {
            return this;
        }
        return new Def<T>(newCode, newValue);
    }
}

