/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Ops;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;

public abstract class AMultiOp<T extends ACell>
extends AOp<T> {
    protected final AVector<AOp<ACell>> ops;
    protected final byte tag;

    protected AMultiOp(byte tag, AVector<AOp<ACell>> ops) {
        this.tag = tag;
        this.ops = ops;
    }

    protected abstract AMultiOp<T> recreate(AVector<AOp<ACell>> var1);

    @Override
    public int encodeAfterOpcode(byte[] bs, int pos) {
        pos = Format.write(bs, pos, this.ops);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + this.ops.estimatedEncodingSize();
    }

    @Override
    public AMultiOp<T> updateRefs(IRefFunction func) {
        ACell newOps = this.ops.updateRefs(func);
        return this.recreate((AVector<AOp<ACell>>)newOps);
    }

    @Override
    public int getRefCount() {
        return this.ops.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.ops.getRef(i);
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        super.validateStructure();
        long n = this.ops.count();
        for (long i = 0L; i < n; ++i) {
            AOp op = Ops.ensureOp(this.ops.get(i));
            if (op != null) continue;
            throw new InvalidDataException("Not an op in position " + i, this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        Cells.validateCell(this.ops);
    }
}

