/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.data.ACell;
import convex.core.data.ASet;
import convex.core.data.AVector;
import convex.core.data.Keyword;
import convex.core.data.Sets;
import convex.core.data.Vectors;
import java.util.HashMap;

public class RecordFormat {
    protected final long count;
    protected final AVector<Keyword> keys;
    protected final HashMap<Keyword, Long> indexes = new HashMap();
    protected final ASet<Keyword> keySet;

    private RecordFormat(AVector<Keyword> keys) {
        this.keys = keys;
        this.count = keys.count();
        this.keySet = Sets.create(keys);
        if (this.keySet.count() != this.count) {
            throw new IllegalArgumentException("Duplicate keys in: " + String.valueOf(keys));
        }
        int i = 0;
        while ((long)i < this.count) {
            this.indexes.put((Keyword)keys.get(i), Long.valueOf(i));
            ++i;
        }
    }

    public long count() {
        return this.count;
    }

    public AVector<Keyword> getKeys() {
        return this.keys;
    }

    public boolean containsKey(Object key) {
        return this.indexes.containsKey(key);
    }

    public static RecordFormat of(Keyword ... keys) {
        return new RecordFormat(Vectors.create((ACell[])keys));
    }

    public ASet<Keyword> keySet() {
        return this.keySet;
    }

    public Long indexFor(Keyword key) {
        return this.indexes.get(key);
    }

    public Keyword getKey(long i) {
        return this.keys.get(i);
    }
}

