/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.cvm.AOp;
import convex.core.cvm.ops.Constant;
import convex.core.cvm.ops.Lambda;
import convex.core.cvm.ops.Query;
import convex.core.cvm.ops.Set;
import convex.core.cvm.ops.Try;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;

public class Ops {
    public static final int OP_DATA_OFFSET = 2;

    public static <T extends ACell> AOp<T> readCodedOp(byte tag, Blob b, int pos) throws BadFormatException {
        byte opCode = b.byteAt(pos + 1);
        switch (opCode) {
            case -80: {
                return Constant.read(b, pos);
            }
            case -70: {
                return Try.read(b, pos);
            }
            case -65: {
                return Lambda.read(b, pos);
            }
            case -69: {
                return Query.read(b, pos);
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return Set.read(b, pos);
            }
        }
        throw new BadFormatException("Invalide OpCode: " + opCode);
    }

    public static <T extends ACell> AOp<T> ensureOp(ACell a) {
        if (a == null) {
            return null;
        }
        if (a instanceof AOp) {
            return (AOp)a;
        }
        return null;
    }

    public static <T extends ACell> AOp<T> castOp(ACell a) {
        if (a == null) {
            return Constant.nil();
        }
        if (a instanceof AOp) {
            return (AOp)a;
        }
        return Constant.create(a);
    }
}

