/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.wallet;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.wallet.AWalletEntry;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.data.Strings;

public class HotWalletEntry
extends AWalletEntry {
    private final AKeyPair keyPair;
    private Hash passHash = null;
    boolean locked = false;
    private String source;

    public HotWalletEntry(AKeyPair kp, String source) {
        super(source);
        this.keyPair = kp;
        this.source = source;
    }

    public static HotWalletEntry create(AKeyPair kp, String source) {
        return new HotWalletEntry(kp, source);
    }

    @Override
    public AccountKey getPublicKey() {
        if (this.keyPair == null) {
            return null;
        }
        return this.keyPair.getAccountKey();
    }

    @Override
    public synchronized AKeyPair getKeyPair() {
        if (this.isLocked()) {
            throw new IllegalStateException("Wallet not unlocked!");
        }
        return this.keyPair;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public String toString() {
        AccountKey pubKey = this.getPublicKey();
        String ks = "0x" + pubKey.toChecksumHex();
        return "Wallet Entry for: " + ks;
    }

    public <R extends ACell> SignedData<R> sign(R message) {
        return this.keyPair.signData(message);
    }

    @Override
    public AArrayBlob getIdenticonData() {
        return this.keyPair.getAccountKey();
    }

    @Override
    public synchronized boolean tryUnlock(char[] password) {
        if (!this.isLocked()) {
            return true;
        }
        Hash h = this.getPasswordHash(password);
        if (h.equals(this.passHash)) {
            this.locked = false;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void lock(char[] password) {
        Hash h = this.getPasswordHash(password);
        if (this.locked) {
            throw new IllegalStateException("Wallet already locked)");
        }
        this.passHash = h;
        this.locked = true;
    }

    protected Hash getPasswordHash(char[] password) {
        String s = new String(password);
        Hash h = Strings.create(s).getHash();
        return h;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean needsLockPassword() {
        return this.passHash == null;
    }

    @Override
    public void lock() {
        this.locked = true;
    }
}

