/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.Providers;
import convex.core.crypto.bc.BCProvider;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class CertUtils {
    public static X509Certificate selfSign(KeyPair keyPair, String subjectDN) throws OperatorCreationException, CertificateException, IOException {
        BouncyCastleProvider bcProvider = BCProvider.BC;
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(subjectDN);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        String signatureAlgorithm = "SHA256WithRSA";
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).build(keyPair.getPrivate());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, keyPair.getPublic());
        BasicConstraints basicConstraints = new BasicConstraints(true);
        certBuilder.addExtension(new ASN1ObjectIdentifier("2.5.29.19"), true, (ASN1Encodable)basicConstraints);
        return new JcaX509CertificateConverter().setProvider((Provider)bcProvider).getCertificate(certBuilder.build(contentSigner));
    }

    public static KeyPair generateRSAKeyPair() throws GeneralSecurityException {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(new RSAKeyGenParameterSpec(3072, RSAKeyGenParameterSpec.F4));
        return kpGen.generateKeyPair();
    }

    public static void createCertificateFiles(String subjectDN, Path path) throws GeneralSecurityException, IOException {
        X509Certificate cert;
        KeyPair kp = CertUtils.generateRSAKeyPair();
        try {
            cert = CertUtils.selfSign(kp, subjectDN);
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException("Failed to self sign certificate", e);
        }
        Path keyPath = path.resolve("private.pem");
        Path certPath = path.resolve("certificate.pem");
        CertUtils.writePemFile(kp.getPrivate().getEncoded(), "PRIVATE KEY", keyPath);
        CertUtils.writePemFile(cert.getEncoded(), "CERTIFICATE", certPath);
    }

    private static void writePemFile(byte[] content, String type, Path file) throws IOException {
        try (PemWriter writer = new PemWriter((Writer)new FileWriter(file.toFile()));){
            PemObject obj = new PemObject(type, content);
            writer.writeObject((PemObjectGenerator)obj);
        }
    }

    public static void main(String ... args) throws OperatorCreationException, GeneralSecurityException, IOException {
        Providers.init();
        CertUtils.createCertificateFiles("CN=localhost, O=o, L=L, ST=il, C=c", Path.of(".", new String[0]));
    }
}

