/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cpos;

import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.util.Comparator;
import java.util.List;

public final class Block
extends ARecordGeneric {
    private static final Keyword[] BLOCK_KEYS = new Keyword[]{Keywords.TIMESTAMP, Keywords.TRANSACTIONS};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCK_KEYS);
    private final long timestamp;
    private AVector<SignedData<ATransaction>> transactions;
    private static final int IX_TIMESTAMP = 0;
    private static final int IX_TRANSACTIONS = 1;
    private static final long NUM_FIELDS = FORMAT.count();
    static final Comparator<SignedData<Block>> TIMESTAMP_COMPARATOR = new Comparator<SignedData<Block>>(){

        @Override
        public int compare(SignedData<Block> a, SignedData<Block> b) {
            Block ba = a.getValue();
            Block bb = b.getValue();
            int sig = Long.compare(ba.getTimeStamp(), bb.getTimeStamp());
            return sig;
        }
    };

    private Block(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        super((byte)-42, FORMAT, Vectors.create(CVMLong.create(timestamp), transactions));
        this.timestamp = timestamp;
        this.transactions = transactions;
    }

    private Block(AVector<ACell> values) {
        super((byte)-42, FORMAT, values);
        this.timestamp = RT.ensureLong((ACell)values.get(0)).longValue();
    }

    @Override
    public ACell get(Keyword k) {
        if (Keywords.TIMESTAMP.equals(k)) {
            return this.values.get(0);
        }
        if (Keywords.TRANSACTIONS.equals(k)) {
            return this.getTransactions();
        }
        return null;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public static Block create(long timestamp, List<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, Vectors.create(transactions));
    }

    public static Block create(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, transactions);
    }

    @SafeVarargs
    public static Block of(long timestamp, SignedData<ATransaction> ... transactions) {
        return new Block(timestamp, Vectors.create((ACell[])transactions));
    }

    public int length() {
        return Utils.checkedInt(this.getTransactions().count());
    }

    @Override
    public int estimatedEncodingSize() {
        return 160;
    }

    public static Block read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        if (values.count() != (long)BLOCK_KEYS.length) {
            throw new BadFormatException("Wrong number of record values");
        }
        Block result = new Block(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    public AVector<SignedData<ATransaction>> getTransactions() {
        if (this.transactions == null) {
            this.transactions = RT.ensureVector((ACell)this.values.get(1));
        }
        return this.transactions;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.values.count() != NUM_FIELDS) {
            throw new InvalidDataException("Wrong field count", this);
        }
    }

    @Override
    public void validateStructure() throws InvalidDataException {
        AVector<SignedData<ATransaction>> txs = this.getTransactions();
        if (txs == null) {
            throw new InvalidDataException("No transactions", this);
        }
        if (txs.count() > 1024L) {
            throw new InvalidDataException("Too many transactions: " + txs.count(), this);
        }
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof Block) {
            return this.equals((Block)a);
        }
        return Cells.equalsGeneric(this, a);
    }

    public boolean equals(Block a) {
        Hash ha;
        if (this == a) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Cells.equals(h, ha);
        }
        return Cells.equals(this.values, a.values);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new Block(this.values);
    }
}

