/*
 * Decompiled with CFR 0.152.
 */
package convex.core.util;

import convex.core.util.Utils;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shutdown {
    public static final int CLIENTHTTP = 60;
    public static final int SERVER = 80;
    public static final int CONNECTION = 90;
    public static final int ETCH = 100;
    public static final int EXECUTOR = 110;
    public static final int CLI = 120;
    private static final Logger log = LoggerFactory.getLogger((String)Shutdown.class.getName());
    private static final TreeMap<Integer, Group> order;

    public static void addHook(int priority, Runnable shutdownTask) {
        Group g = order.get(priority);
        if (g == null) {
            g = new Group(priority);
            order.put(priority, g);
        }
        g.addHook(shutdownTask);
    }

    private static void runHooks() {
        for (Map.Entry<Integer, Group> me : order.entrySet()) {
            log.debug("Running shutdown hooks at level: " + String.valueOf(me.getKey()));
            me.getValue().runHooks();
        }
        order.clear();
        log.debug("Convex shutdown hooks complete");
    }

    public void shoutDownNow() {
        Shutdown.runHooks();
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    log.debug("Running Convex shutdown hooks");
                    Shutdown.runHooks();
                }
            }, "Convex Shutdown"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        order = new TreeMap();
    }

    protected static class Group {
        protected final int level;
        private final IdentityHashMap<Runnable, Runnable> hookSet = new IdentityHashMap();

        public Group(int level) {
            this.level = level;
        }

        public synchronized void addHook(Runnable r) {
            this.hookSet.put(r, r);
        }

        public synchronized void runHooks() {
            Set<Runnable> hooks = this.hookSet.keySet();
            hooks.stream().forEach(r -> {
                log.trace("Running shutdown hook: " + Utils.getClassName(r));
                try {
                    r.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            this.hookSet.clear();
        }
    }
}

