/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.cvm.AFn;
import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.Symbols;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Vectors;
import convex.core.data.prim.ByteFlag;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.lang.impl.AClosure;
import convex.core.lang.impl.MultiFn;

public class Fn<T extends ACell>
extends AClosure<T> {
    private static final ByteFlag CODE = new ByteFlag(-80);
    private Long variadic = null;

    private Fn(AVector<ACell> data) {
        super(data);
    }

    public static <T extends ACell, I> Fn<T> create(AVector<ACell> params, AOp<T> body) {
        AVector<ACell> data = Vectors.create(CODE, params, null, body);
        return new Fn<T>(data);
    }

    public static <T extends ACell, I> Fn<T> create(AVector<ACell> data) throws BadFormatException {
        if (data.count() != 4L) {
            throw new BadFormatException("Invalid function data length");
        }
        if (!data.getRef(0).isEmbedded()) {
            throw new BadFormatException("Non-embedded Fn type");
        }
        return new Fn<T>(data);
    }

    @Override
    protected AFn<T> recreate(AVector<ACell> newData) {
        return new Fn<T>(newData);
    }

    @Override
    public <F extends AClosure<T>> F withEnvironment(AVector<ACell> env) {
        if (this.getLexicalEnvironment() == env) {
            return (F)this;
        }
        return (F)new Fn<T>((AVector<ACell>)this.data.assoc(2L, (ACell)env));
    }

    public AVector<ACell> getLexicalEnvironment() {
        AVector env = RT.ensureVector((ACell)this.data.get(2));
        if (env == null) {
            env = EMPTY_BINDINGS;
        }
        return env;
    }

    @Override
    public boolean hasArity(int n) {
        long var = this.checkVariadic();
        long pc = this.getParams().count();
        if (var >= 0L) {
            return (long)n >= pc - 2L;
        }
        return (long)n == pc;
    }

    private Long checkVariadic() {
        if (this.variadic != null) {
            return this.variadic;
        }
        AVector<ACell> params = this.getParams();
        long pc = params.count();
        int i = 0;
        while ((long)i < pc - 1L) {
            Object param = params.get(i);
            if (Symbols.AMPERSAND.equals((ACell)param)) {
                this.variadic = i + 1;
                return this.variadic;
            }
            ++i;
        }
        this.variadic = -1L;
        return -1L;
    }

    @Override
    public Context invoke(Context context, ACell[] args) {
        AVector<ACell> savedBindings = context.getLocalBindings();
        Context boundContext = (context = context.withLocalBindings(this.getLexicalEnvironment())).updateBindings(this.getParams(), args);
        if (boundContext.isExceptional()) {
            return boundContext.withLocalBindings(savedBindings);
        }
        Context ctx = boundContext.execute(this.getBody());
        return ctx.withLocalBindings(savedBindings);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public static <T extends ACell> AClosure<T> read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> data = Vectors.read(b, pos);
        long n = data.count();
        if (n == 0L) {
            throw new BadFormatException("Empty record in Fn");
        }
        byte type = b.byteAtUnchecked(pos + 1 + Format.getVLQCountLength(n));
        AClosure result = switch (type) {
            case -80 -> Fn.create(data);
            default -> MultiFn.create(data);
        };
        int epos = pos + data.getEncodingLength();
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(fn ");
        this.printInternal(sb, limit);
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    public boolean printInternal(BlobBuilder sb, long limit) {
        sb.append('[');
        AVector<ACell> params = this.getParams();
        long size = params.count();
        for (long i = 0L; i < size; ++i) {
            if (i > 0L) {
                sb.append(' ');
            }
            if (RT.print(sb, params.get(i), limit)) continue;
            return false;
        }
        sb.append(']');
        sb.append(' ');
        return this.getBody().print(sb, limit);
    }

    public AVector<ACell> getParams() {
        AVector<ACell> result = RT.ensureVector((ACell)this.data.get(1));
        return result;
    }

    public AOp<T> getBody() {
        AOp result = Ops.ensureOp((ACell)this.data.get(3));
        return result;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    public static <T extends ACell> AClosure<T> ensureFunction(ACell a) {
        if (a instanceof AClosure) {
            return (AClosure)a;
        }
        return null;
    }
}

