/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Strings;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.ANumeric;
import convex.core.data.prim.CVMBigInteger;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Bits;
import convex.core.util.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class CVMDouble
extends ANumeric {
    public static final CVMDouble ZERO = new CVMDouble(0.0);
    public static final CVMDouble NEGATIVE_ZERO = new CVMDouble(-0.0);
    public static final CVMDouble ONE = new CVMDouble(1.0);
    public static final CVMDouble MINUS_ONE = new CVMDouble(-1.0);
    public static final CVMDouble NaN = new CVMDouble(Double.NaN);
    public static final CVMDouble POSITIVE_INFINITY = new CVMDouble(Double.POSITIVE_INFINITY);
    public static final CVMDouble NEGATIVE_INFINITY = new CVMDouble(Double.NEGATIVE_INFINITY);
    private final double value;
    private static final long RAW_NAN_BITS = 9221120237041090560L;
    public static final int MAX_ENCODING_LENGTH = 9;

    private CVMDouble(double value) {
        this.value = value;
        this.memorySize = 0L;
    }

    public static CVMDouble create(double value) {
        if (Double.isNaN(value)) {
            return NaN;
        }
        return new CVMDouble(value);
    }

    public static CVMDouble unsafeCreate(double value) {
        return new CVMDouble(value);
    }

    @Override
    public AType getType() {
        return Types.DOUBLE;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public CVMLong toLong() {
        return CVMLong.create(this.longValue());
    }

    @Override
    public CVMDouble toDouble() {
        if (!Double.isNaN(this.value)) {
            return this;
        }
        return NaN;
    }

    @Override
    public CVMDouble signum() {
        if (this.value > 0.0) {
            return ONE;
        }
        if (this.value < 0.0) {
            return MINUS_ONE;
        }
        if (Double.isNaN(this.value)) {
            return NaN;
        }
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        return 9;
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    protected static final boolean isStandardNaN(double value) {
        return Double.doubleToRawLongBits(value) == 9221120237041090560L;
    }

    @Override
    public boolean isCVMValue() {
        return true;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 29;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        long doubleBits = Double.doubleToRawLongBits(this.value);
        return Utils.writeLong(bs, pos, doubleBits);
    }

    @Override
    public String toString() {
        if (Double.isInfinite(this.value)) {
            if (this.value > 0.0) {
                return "##Inf";
            }
            return "##-Inf";
        }
        if (Double.isNaN(this.value)) {
            long bits = Double.doubleToRawLongBits(this.value);
            if (bits == 9221120237041090560L) {
                return "##NaN";
            }
            return "#[1d" + Utils.toHexString(bits) + "]";
        }
        return Double.toString(this.value);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toString());
        return bb.count() <= limit;
    }

    @Override
    public Class<?> numericType() {
        return Double.class;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMDouble parse(String s) {
        try {
            double d = Double.parseDouble(s);
            return CVMDouble.create(d);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public final byte getTag() {
        return 29;
    }

    public static CVMDouble read(byte tag, Blob blob, int offset) throws BadFormatException {
        if (blob.count() < (long)(offset + 1 + 8)) {
            throw new BadFormatException("Insufficient blob bytes to read Double");
        }
        long bits = Utils.readLong(blob.getInternalArray(), blob.getInternalOffset() + offset + 1, 8);
        double d = Double.longBitsToDouble(bits);
        CVMDouble result = CVMDouble.unsafeCreate(d);
        result.attachEncoding(blob.slice(offset, offset + 1 + 8));
        return result;
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 1L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public boolean equals(ACell a) {
        if (a == this) {
            return true;
        }
        if (!(a instanceof CVMDouble)) {
            return false;
        }
        return this.equals((CVMDouble)a);
    }

    public boolean equals(CVMDouble a) {
        return this.longBits() == a.longBits();
    }

    private final long longBits() {
        return Double.doubleToRawLongBits(this.value);
    }

    @Override
    public int hashCode() {
        return Bits.hash32(this.longBits());
    }

    @Override
    public ANumeric abs() {
        if (this.value > 0.0) {
            return this;
        }
        if (this.value == 0.0) {
            return ZERO;
        }
        return CVMDouble.create(-this.value);
    }

    @Override
    public int compareTo(ANumeric o) {
        return Double.compare(this.value, o.doubleValue());
    }

    @Override
    public CVMLong ensureLong() {
        return null;
    }

    @Override
    public ANumeric add(ANumeric b) {
        return CVMDouble.create(this.value + b.doubleValue());
    }

    @Override
    public ANumeric sub(ANumeric b) {
        return CVMDouble.create(this.value - b.doubleValue());
    }

    @Override
    public ANumeric negate() {
        return CVMDouble.create(-this.value);
    }

    @Override
    public ANumeric multiply(ANumeric b) {
        return CVMDouble.create(this.value * b.doubleValue());
    }

    @Override
    public AInteger toInteger() {
        if (!Double.isFinite(this.value)) {
            return null;
        }
        if (this.value <= 9.223372036854776E18 && this.value >= -9.223372036854776E18) {
            return CVMLong.create((long)this.value);
        }
        BigDecimal bd = BigDecimal.valueOf(this.value);
        BigInteger bi = bd.toBigInteger();
        return CVMBigInteger.wrap(bi);
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }
}

