/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.Ref;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.ByteFlag;
import convex.core.data.prim.CVMBool;
import convex.core.exceptions.InvalidDataException;

public abstract class AByteFlag
extends APrimitive {
    public static final int MAX_ENCODING_LENGTH = 1;

    @Override
    public int estimatedEncodingSize() {
        return 1;
    }

    public static AByteFlag read(byte tag) {
        tag = (byte)(tag & 0xF);
        switch (tag) {
            case 0: {
                return CVMBool.FALSE;
            }
            case 1: {
                return CVMBool.TRUE;
            }
        }
        return ByteFlag.unsafeCreate(tag);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        byte tag = this.getTag();
        if ((tag & 0xF0) != 176) {
            throw new InvalidDataException("Illegal byte flag tag: " + tag, this);
        }
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        throw new IndexOutOfBoundsException(i);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return pos;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return pos;
    }

    public static AByteFlag create(long value) {
        if (value == 1L) {
            return CVMBool.TRUE;
        }
        if (value == 0L) {
            return CVMBool.FALSE;
        }
        return ByteFlag.create(value);
    }
}

