/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorTree;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.ErrorMessages;
import convex.core.util.Utils;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class VectorLeaf<T extends ACell>
extends AVector<T> {
    public static final VectorLeaf<?> EMPTY = Cells.intern(new VectorLeaf(new Ref[0]));
    public static final Ref<VectorLeaf<?>> EMPTY_REF = EMPTY.getRef();
    public static final int MAX_SIZE = 16;
    private Ref<AVector<T>> prefix;
    private final Ref<T>[] items;
    public static final int MAX_ENCODING_LENGTH = 2390;

    VectorLeaf(Ref<T>[] items, Ref<AVector<T>> prefix, long count) {
        super(count);
        this.items = items;
        this.prefix = prefix;
    }

    VectorLeaf(Ref<T>[] items) {
        this(items, null, items.length);
    }

    public static <T extends ACell> VectorLeaf<T> create(ACell[] elements, int offset, int length) {
        if (length == 0) {
            return EMPTY;
        }
        if (length > 16) {
            throw new IllegalArgumentException("Too many elements for VectorLeaf: " + length);
        }
        Ref[] items = new Ref[length];
        for (int i = 0; i < length; ++i) {
            ACell value = elements[i + offset];
            items[i] = Ref.get(value);
        }
        return new VectorLeaf<T>(items);
    }

    public static <T extends ACell> VectorLeaf<T> create(ACell[] elements, int offset, int length, AVector<T> prefix) {
        if (length == 0) {
            throw new IllegalArgumentException("VectorLeaf with tail cannot be created with zero head elements");
        }
        if (length > 16) {
            throw new IllegalArgumentException("Too many elements for VectorLeaf: " + length);
        }
        Ref[] items = new Ref[length];
        for (int i = 0; i < length; ++i) {
            ACell value = elements[i + offset];
            items[i] = Ref.get(value);
        }
        return new VectorLeaf<T>(items, prefix.getRef(), prefix.count() + (long)length);
    }

    public static <T extends ACell> VectorLeaf<T> create(T[] things) {
        return VectorLeaf.create(things, 0, things.length);
    }

    @Override
    public final AVector<T> toVector() {
        return this;
    }

    @Override
    public AVector<T> append(T value) {
        int localSize = this.items.length;
        if (localSize < 16) {
            Ref[] newItems = new Ref[localSize + 1];
            System.arraycopy(this.items, 0, newItems, 0, localSize);
            newItems[localSize] = Ref.get(value);
            if (localSize + 1 == 16) {
                VectorLeaf<T> chunk = new VectorLeaf<T>(newItems);
                if (!this.hasPrefix()) {
                    return chunk;
                }
                return this.prefix.getValue().appendChunk(chunk);
            }
            return new VectorLeaf<T>(newItems, this.prefix, this.count + 1L);
        }
        VectorLeaf newPrefix = this;
        return new VectorLeaf<T>(new Ref[]{Ref.get(value)}, newPrefix.getRef(), this.count + 1L);
    }

    @Override
    public AVector<T> concat(ASequence<? extends T> b) {
        long aLen = this.count();
        long bLen = b.count();
        AVector result = this;
        long i = aLen;
        long end = aLen + bLen;
        while (i < end) {
            int rn;
            if ((i & 0xFL) == 0L && (rn = Utils.checkedInt(Math.min(16L, end - i))) == 16) {
                result = result.appendChunk(b.subVector(i - aLen, rn));
                i += 16L;
                continue;
            }
            result = result.append(b.get(i - aLen));
            ++i;
        }
        return result;
    }

    @Override
    public AVector<T> appendChunk(AVector<T> chunk) {
        if (chunk.count != 16L) {
            throw new IllegalArgumentException("Can't append a chunk of size: " + chunk.count());
        }
        if (this.count == 0L) {
            return chunk;
        }
        if (this.hasPrefix()) {
            throw new IllegalArgumentException("Can't append chunk to a VectorLeaf with a tail (length = " + this.count + ")");
        }
        if (this.count != 16L) {
            throw new IllegalArgumentException("Can't append chunk to a VectorLeaf of size: " + this.count);
        }
        return VectorTree.wrap2((VectorLeaf)chunk.toVector(), this);
    }

    @Override
    public T get(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.getElementRefUnsafe(i).getValue();
    }

    @Override
    public Ref<T> getElementRef(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.getElementRefUnsafe(i);
    }

    @Override
    protected Ref<T> getElementRefUnsafe(long i) {
        long ix = i - this.prefixLength();
        if (ix >= 0L) {
            return this.items[(int)ix];
        }
        return this.prefix.getValue().getElementRefUnsafe(i);
    }

    @Override
    public AVector<T> assoc(long i, T value) {
        ASequence newTail;
        if (i < 0L || i >= this.count) {
            return null;
        }
        long ix = i - this.prefixLength();
        if (ix >= 0L) {
            T old = this.items[(int)ix].getValue();
            if (old == value) {
                return this;
            }
            Ref[] newItems = (Ref[])this.items.clone();
            newItems[(int)ix] = Ref.get(value);
            return new VectorLeaf<T>(newItems, this.prefix, this.count);
        }
        AVector<T> tl = this.prefix.getValue();
        if (tl == (newTail = tl.assoc(i, (ACell)value))) {
            return this;
        }
        return new VectorLeaf<T>(this.items, newTail.getRef(), this.count);
    }

    public static <T extends ACell> VectorLeaf<T> read(long count, Blob b, int pos) throws BadFormatException {
        boolean prefixPresent;
        if (count == 0L) {
            return EMPTY;
        }
        int n = (int)count & 0xF;
        if (n == 0) {
            if (count > 16L) {
                throw new BadFormatException("Vector not valid for size 0 mod 16: " + count);
            }
            n = 16;
        }
        int rpos = pos + 1 + Format.getVLQCountLength(count);
        Ref[] items = new Ref[n];
        for (int i = 0; i < n; ++i) {
            Ref ref;
            items[i] = ref = Format.readRef(b, rpos);
            rpos = (int)((long)rpos + ref.getEncodingLength());
        }
        Ref<AVector<T>> pfx = null;
        boolean bl = prefixPresent = count > 16L;
        if (prefixPresent) {
            pfx = Format.readRef(b, rpos);
            rpos = (int)((long)rpos + pfx.getEncodingLength());
        }
        VectorLeaf<T> result = new VectorLeaf<T>(items, pfx, count);
        if (b.byteAtUnchecked(pos) == -128) {
            result.attachEncoding(b.slice(pos, rpos));
        }
        return result;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -128;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        int ilength = this.items.length;
        boolean hasPrefix = this.hasPrefix();
        pos = Format.writeVLQCount(bs, pos, this.count);
        for (int i = 0; i < ilength; ++i) {
            pos = this.items[i].encode(bs, pos);
        }
        if (hasPrefix) {
            pos = this.prefix.encode(bs, pos);
        }
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        if (this.count < 2L) {
            if (this.count == 0L) {
                return 2;
            }
            return 142;
        }
        int ESTIMATED_REF_SIZE = 70;
        return 10 + ESTIMATED_REF_SIZE * (this.items.length + 2);
    }

    @Override
    public int getEncodingLength() {
        if (this.encoding != null) {
            return this.encoding.size();
        }
        int length = 1 + Format.getVLQCountLength(this.count);
        int n = this.items.length;
        if (this.prefix != null) {
            length = (int)((long)length + this.prefix.getEncodingLength());
        }
        for (int i = 0; i < n; ++i) {
            length = (int)((long)length + this.items[i].getEncodingLength());
        }
        return length;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public VectorLeaf<T> withPrefix(AVector<T> newPrefix) {
        long newPC;
        if (newPrefix == null && !this.hasPrefix()) {
            return this;
        }
        long l = newPC = newPrefix == null ? 0L : newPrefix.count();
        if ((newPC & 0xFL) != 0L) {
            throw new IllegalArgumentException("Prefix must be fully packed!");
        }
        return new VectorLeaf<T>(this.items, newPrefix == null ? null : newPrefix.getRef(), newPC + (long)this.items.length);
    }

    @Override
    public boolean isFullyPacked() {
        return !this.hasPrefix() && this.items.length == 16;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(long index) {
        return new ListVectorIterator(index);
    }

    public long prefixLength() {
        return this.count - (long)this.items.length;
    }

    @Override
    protected <K> void copyToArray(K[] arr, int offset) {
        int s = this.size();
        if (this.prefix != null) {
            this.prefix.getValue().copyToArray(arr, offset);
        }
        int ilen = this.items.length;
        for (int i = 0; i < ilen; ++i) {
            T value = this.items[i].getValue();
            arr[offset + s - ilen + i] = value;
        }
    }

    @Override
    public long longIndexOf(ACell o) {
        long pi;
        if (this.prefix != null && (pi = this.prefix.getValue().longIndexOf(o)) >= 0L) {
            return pi;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (!Utils.equals(this.items[i].getValue(), o)) continue;
            return this.count - (long)this.items.length + (long)i;
        }
        return -1L;
    }

    @Override
    public long longLastIndexOf(ACell o) {
        long ti;
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (!Utils.equals(this.items[i].getValue(), o)) continue;
            return this.count - (long)this.items.length + (long)i;
        }
        if (this.prefix != null && (ti = this.prefix.getValue().longLastIndexOf(o)) >= 0L) {
            return ti;
        }
        return -1L;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        if (this.prefix != null) {
            this.prefix.getValue().forEach(action);
            for (Ref<T> r : this.items) {
                action.accept(r.getValue());
            }
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super T> pred) {
        if (this.prefix != null && this.prefix.getValue().anyMatch(pred)) {
            return true;
        }
        for (Ref<T> r : this.items) {
            if (!pred.test(r.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super T> pred) {
        if (this.prefix != null && !this.prefix.getValue().allMatch(pred)) {
            return false;
        }
        for (Ref<T> r : this.items) {
            if (pred.test(r.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<? super T, ? extends R> mapper) {
        Ref<AVector<AVector<T>>> newPrefix = this.prefix == null ? null : this.prefix.getValue().map((Function)mapper).getRef();
        int ilength = this.items.length;
        Ref[] newItems = new Ref[ilength];
        for (int i = 0; i < ilength; ++i) {
            Ref<T> iref = this.items[i];
            ACell r = (ACell)mapper.apply(iref.getValue());
            newItems[i] = Ref.get(r);
        }
        return this.prefix == null ? new VectorLeaf<T>(newItems) : new VectorLeaf<T>(newItems, newPrefix, this.count);
    }

    @Override
    public void visitElementRefs(Consumer<Ref<T>> f) {
        if (this.prefix != null) {
            this.prefix.getValue().visitElementRefs(f);
        }
        for (Ref<T> item : this.items) {
            f.accept(item);
        }
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super T, ? extends R> func, R value) {
        if (this.prefix != null) {
            value = this.prefix.getValue().reduce(func, value);
        }
        int ilength = this.items.length;
        for (int i = 0; i < ilength; ++i) {
            value = func.apply(value, this.items[i].getValue());
        }
        return value;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public int getRefCount() {
        return this.items.length + (this.hasPrefix() ? 1 : 0);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (this.prefix != null) {
            if (i == 0) {
                return this.prefix;
            }
            --i;
        }
        int itemsCount = this.items.length;
        if (i < 0) {
            throw new IndexOutOfBoundsException("Negative Ref index: " + i);
        }
        if (i < itemsCount) {
            return this.items[i];
        }
        throw new IndexOutOfBoundsException("Ref index out of range: " + i);
    }

    @Override
    public VectorLeaf<T> updateRefs(IRefFunction func) {
        Ref newPrefix = this.prefix == null ? null : func.apply(this.prefix);
        int ic = this.items.length;
        Ref<T>[] newItems = this.items;
        for (int i = 0; i < ic; ++i) {
            Ref<T> current = this.items[i];
            Ref newItem = func.apply(current);
            if (newItem == current) continue;
            if (this.items == newItems) {
                newItems = (Ref[])this.items.clone();
            }
            newItems[i] = newItem;
        }
        if (this.items == newItems && this.prefix == newPrefix) {
            return this;
        }
        VectorLeaf<T> result = new VectorLeaf<T>(newItems, newPrefix, this.count);
        result.attachEncoding(this.encoding);
        return result;
    }

    @Override
    public boolean equals(AVector<? super T> a) {
        if (a instanceof VectorLeaf) {
            return this.equals((VectorLeaf)a);
        }
        if (!(a instanceof AVector)) {
            return false;
        }
        AVector<T> v = a;
        if (v.count() != this.count) {
            return false;
        }
        return a.getEncoding().equals(this.getEncoding());
    }

    @Override
    public boolean equals(VectorLeaf<T> v) {
        if (this == v) {
            return true;
        }
        if (this.count != v.count()) {
            return false;
        }
        if (!Utils.equals(this.prefix, v.prefix)) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].equals(v.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long commonPrefixLength(AVector<T> b) {
        long prefixMatchLength;
        long n = this.count();
        if (this == b) {
            return n;
        }
        int il = this.items.length;
        long prefixLength = n - (long)il;
        if (prefixLength > 0L && (prefixMatchLength = this.prefix.getValue().commonPrefixLength(b)) < prefixLength) {
            return prefixMatchLength;
        }
        long nn = Math.min(n, b.count()) - prefixLength;
        if (nn == 0L) {
            return prefixLength;
        }
        VectorLeaf<T> bChunk = b.getChunk(prefixLength);
        int i = 0;
        while ((long)i < nn) {
            if (!this.items[i].equals(bChunk.items[i])) {
                return prefixLength + (long)i;
            }
            ++i;
        }
        return prefixLength + nn;
    }

    @Override
    public VectorLeaf<T> getChunk(long offset) {
        if (this.prefix == null) {
            if (offset == 0L) {
                return this;
            }
        } else {
            AVector<T> pre = this.prefix.getValue();
            long prefixLength = pre.count();
            if (offset < prefixLength) {
                return this.prefix.getValue().getChunk(offset);
            }
            if (offset == prefixLength) {
                return this;
            }
        }
        throw new IndexOutOfBoundsException("Invalid chunk offset: " + offset + " in vector of length " + this.count);
    }

    @Override
    public AVector<T> slice(long start, long end) {
        if (!this.checkRange(start, end)) {
            return null;
        }
        if (start == end) {
            return EMPTY;
        }
        if (start == 0L && end == this.count) {
            return this;
        }
        long tc = this.prefixLength();
        if (start >= tc) {
            int len = (int)(end - start);
            Ref[] newItems = new Ref[len];
            System.arraycopy(this.items, Utils.checkedInt(start - tc), newItems, 0, len);
            return new VectorLeaf<T>(newItems, null, len);
        }
        AVector<T> tv = this.prefix.getValue();
        if (end <= tc) {
            return tv.slice(start, end);
        }
        return ((AVector)tv.slice(start, tc)).concat(this.slice(tc, end));
    }

    @Override
    public AVector<T> next() {
        if (this.count <= 1L) {
            return null;
        }
        return this.slice(1L, this.count);
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.prefix != null) {
            if (this.count == 16L) {
                throw new InvalidDataException("Full VectorLeaf with prefix? This is not right...", this);
            }
            if (this.count == 0L) {
                throw new InvalidDataException("Empty VectorLeaf with prefix? This is not right...", this);
            }
            AVector<T> ccell = this.prefix.getValue();
            if (!(ccell instanceof AVector)) {
                throw new InvalidDataException("Prefix is not a vector", this);
            }
            AVector<T> tv = ccell;
            if (this.prefixLength() != tv.count()) {
                throw new InvalidDataException("Expected prefix length: " + this.prefixLength() + " but found " + tv.count(), this);
            }
            tv.validate();
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.count > 0L && this.items.length == 0) {
            throw new InvalidDataException("Should be items present!", this);
        }
    }

    public static final boolean isValidCount(long count) {
        return count <= 16L || (count & 0xFL) != 0L;
    }

    @Override
    protected void visitAllChildren(Consumer<AVector<T>> visitor) {
        if (this.hasPrefix()) {
            AVector<T> child = this.prefix.getValue();
            child.visitAllChildren(visitor);
            visitor.accept(child);
        }
    }

    @Override
    public AVector<T> dissocAt(long i) {
        if (i < 0L || i >= this.count) {
            return null;
        }
        long pl = this.prefixLength();
        if (i >= pl) {
            int cn = this.items.length;
            if (cn == 1) {
                return pl == 0L ? Vectors.empty() : this.prefix.getValue();
            }
            int ci = (int)(i - pl);
            Ref<T>[] newItems = Arrays.copyOf(this.items, cn - 1);
            System.arraycopy(this.items, ci + 1, newItems, ci, cn - ci - 1);
            return new VectorLeaf<T>(newItems, this.prefix, this.count - 1L);
        }
        return ((AVector)this.slice(0L, i)).concat(this.slice(i + 1L, this.count));
    }

    private class ListVectorIterator
    implements ListIterator<T> {
        ListIterator<T> prefixIterator;
        int pos;

        public ListVectorIterator(long index) {
            if (index < 0L) {
                throw new IndexOutOfBoundsException((int)index);
            }
            long tc = VectorLeaf.this.prefixLength();
            if (index >= tc) {
                if (index > VectorLeaf.this.count) {
                    throw new IndexOutOfBoundsException((int)index);
                }
                this.pos = (int)(index - tc);
                this.prefixIterator = VectorLeaf.this.prefix == null ? null : VectorLeaf.this.prefix.getValue().listIterator(tc);
            } else {
                this.pos = 0;
                this.prefixIterator = VectorLeaf.this.prefix == null ? null : VectorLeaf.this.prefix.getValue().listIterator(index);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.prefixIterator != null && this.prefixIterator.hasNext()) {
                return true;
            }
            return this.pos < VectorLeaf.this.items.length;
        }

        @Override
        public T next() {
            if (this.prefixIterator != null && this.prefixIterator.hasNext()) {
                return (ACell)this.prefixIterator.next();
            }
            return VectorLeaf.this.items[this.pos++].getValue();
        }

        @Override
        public boolean hasPrevious() {
            if (this.pos > 0) {
                return true;
            }
            if (this.prefixIterator != null) {
                return this.prefixIterator.hasPrevious();
            }
            return false;
        }

        @Override
        public T previous() {
            if (this.pos > 0) {
                return VectorLeaf.this.items[--this.pos].getValue();
            }
            if (this.prefixIterator != null) {
                return (ACell)this.prefixIterator.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            if (this.prefixIterator != null && this.prefixIterator.hasNext()) {
                return this.prefixIterator.nextIndex();
            }
            return Utils.checkedInt(VectorLeaf.this.prefixLength() + (long)this.pos);
        }

        @Override
        public int previousIndex() {
            if (this.pos > 0) {
                return Utils.checkedInt(VectorLeaf.this.prefixLength() + (long)this.pos - 1L);
            }
            if (this.prefixIterator != null) {
                return this.prefixIterator.previousIndex();
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(ErrorMessages.immutable(this));
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException(ErrorMessages.immutable(this));
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException(ErrorMessages.immutable(this));
        }
    }
}

