/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AExtensionValue;
import convex.core.data.Format;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public class ExtensionValue
extends AExtensionValue {
    protected final byte tag;

    protected ExtensionValue(byte tag, long value) {
        super(value);
        this.tag = tag;
    }

    public static ExtensionValue create(byte tag, long value) {
        if (value < 0L) {
            return null;
        }
        if ((byte)(tag & 0xF0) != -32) {
            return null;
        }
        return new ExtensionValue(tag, value);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if ((byte)(this.tag & 0xF0) != -32) {
            throw new InvalidDataException("Invalide Code tag: 0x" + Utils.toHexString(this.tag), this);
        }
        if (this.value < 0L) {
            throw new InvalidDataException("Negaitive code value", this);
        }
    }

    @Override
    public final byte byteAt(long i) {
        ExtensionValue.checkIndex(i);
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final byte byteAtUnchecked(long i) {
        return (byte)Utils.longByteAt(this.value, i);
    }

    @Override
    public final int getBytes(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.value);
        return pos;
    }

    @Override
    public byte getTag() {
        return this.tag;
    }

    @Override
    public boolean isCanonical() {
        return this.value >= 0L;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.tag;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.value);
        return pos;
    }

    @Override
    public boolean isCVMValue() {
        return false;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return RT.printCAD3(sb, limit, this);
    }
}

