/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.Hashing;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.Panic;
import convex.core.util.Bits;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public abstract class ABlob
extends ABlobLike<CVMLong> {
    protected final long count;

    protected ABlob(long count) {
        this.count = count;
    }

    public boolean isChunkPacked() {
        return (this.count & 0xFFFL) == 0L;
    }

    public abstract boolean isFullyPacked();

    @Override
    public final int size() {
        return Utils.checkedInt(this.count);
    }

    @Override
    public final AType getType() {
        return Types.BLOB;
    }

    @Override
    public final long count() {
        return this.count;
    }

    @Override
    public CVMLong get(long ix) {
        return CVMLong.forByte(this.byteAt(ix));
    }

    @Override
    public Ref<CVMLong> getElementRef(long index) {
        return this.get(index).getRef();
    }

    @Override
    public final Blob empty() {
        return Blob.EMPTY;
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getBytes());
    }

    public abstract ABlob slice(long var1, long var3);

    public ABlob slice(long start) {
        return this.slice(start, this.count());
    }

    @Override
    public abstract Blob toFlatBlob();

    @Override
    public final ABlob toBlob() {
        return this;
    }

    public Hash getContentHash() {
        return this.computeHash(Hashing.getDigest());
    }

    public final Hash computeHash(MessageDigest digest) {
        this.updateDigest(digest);
        return Hash.wrap(digest.digest());
    }

    public abstract void updateDigest(MessageDigest var1);

    @Override
    public byte byteAt(long i) {
        if (i < 0L || i >= this.count()) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.byteAtUnchecked(i);
    }

    public abstract ABlob append(ABlob var1);

    @Override
    public boolean equals(ACell o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ABlob)) {
            return false;
        }
        return this.equals((ABlob)o);
    }

    public abstract boolean equals(ABlob var1);

    @Override
    protected abstract ABlob toCanonical();

    public abstract boolean equalsBytes(byte[] var1, long var2);

    @Override
    public int compareTo(ABlobLike<?> b) {
        if (this == b) {
            return 0;
        }
        long alength = this.count();
        long blength = b.count();
        long compareLength = Math.min(alength, blength);
        for (long i = 0L; i < compareLength; ++i) {
            int c = (0xFF & this.byteAtUnchecked(i)) - (0xFF & b.byteAtUnchecked(i));
            if (c > 0) {
                return 1;
            }
            if (c >= 0) continue;
            return -1;
        }
        if (alength > compareLength) {
            return 1;
        }
        if (blength > compareLength) {
            return -1;
        }
        return 0;
    }

    public abstract Blob getChunk(long var1);

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(Strings.HEX_PREFIX);
        return this.appendHex(bb, limit - bb.count());
    }

    public abstract ByteBuffer getByteBuffer();

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    protected void validateCell() throws InvalidDataException {
        if (this.count() < 0L) {
            throw new InvalidDataException("Negative blob length", this);
        }
    }

    @Override
    public final int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);

    @Override
    public int hashCode() {
        return Bits.hash32(this.longValue());
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public final byte getTag() {
        return 49;
    }

    @Override
    public abstract boolean equalsBytes(ABlob var1);

    public short shortAt(long i) {
        byte hi = this.byteAt(i);
        byte lo = this.byteAt(i + 1L);
        return (short)(hi << 8 | lo & 0xFF);
    }

    public int toByteBuffer(long offset, ByteBuffer dest) {
        long n = Math.min(this.count() - offset, (long)dest.remaining());
        return this.toByteBuffer(offset, n, dest);
    }

    public abstract int toByteBuffer(long var1, long var3, ByteBuffer var5);

    public ABlob replaceSlice(long position, ABlob b) {
        long end = Math.min(position + b.count(), this.count());
        ABlob head = this.slice(0L, position);
        if (head == null) {
            throw new IllegalArgumentException("Invalid " + position + " in blob of size " + this.count());
        }
        ABlob tail = this.slice(end, this.count());
        ABlob firstPart = head.append(b);
        ABlob result = firstPart.append(tail);
        if (result.count() < 0L) {
            throw new Panic("Blob with negative size?? This is bad!!");
        }
        return result;
    }
}

