/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.ErrorCodes;
import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Bits;

public class Local<T extends ACell>
extends AOp<T> {
    private final long position;

    private Local(long position) {
        this.position = position;
    }

    public static final <R extends ACell> Local<R> create(long position) {
        if (position < 0L) {
            return null;
        }
        return new Local(position);
    }

    @Override
    public Context execute(Context ctx) {
        AVector<ACell> env = ctx.getLocalBindings();
        long ec = env.count();
        if (this.position < 0L || this.position >= ec) {
            return ctx.withError(ErrorCodes.BOUNDS, "Bad position for Local: " + this.position).consumeJuice(15L);
        }
        ACell result = env.get(this.position);
        return ctx.withResult(15L, result);
    }

    @Override
    public byte getTag() {
        return -26;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLQCount(bs, pos, this.position);
        return pos;
    }

    @Override
    public int encodeAfterOpcode(byte[] bs, int pos) {
        throw new Error("Should be unreachable");
    }

    @Override
    public Local<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.position < 0L) {
            throw new InvalidDataException("Invalid Local position " + this.position, this);
        }
    }

    @Override
    public final int hashCode() {
        return Bits.hash32(this.position);
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toString());
        return bb.check(limit);
    }

    @Override
    public String toString() {
        return "%" + this.position;
    }
}

