/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.ops.ACodedOp;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Ref;
import convex.core.data.prim.ByteFlag;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.impl.AClosure;
import convex.core.lang.impl.Fn;
import convex.core.util.Utils;

public class Lambda<T extends ACell>
extends ACodedOp<T, ACell, AClosure<T>> {
    private static final Ref<ACell> OPCODE = new ByteFlag(-65).getRef();

    protected Lambda(Ref<AClosure<T>> newFunction) {
        super((byte)-64, OPCODE, newFunction);
    }

    public static <T extends ACell> Lambda<T> create(AVector<ACell> params, AOp<T> body) {
        return new Lambda<T>(Fn.create(params, body).getRef());
    }

    public static <T extends ACell> Lambda<T> create(AClosure<T> fn) {
        return new Lambda<T>(fn.getRef());
    }

    @Override
    public Context execute(Context context) {
        Object fn = ((AClosure)this.value.getValue()).withEnvironment(context.getLocalBindings());
        return context.withResult(100L, (ACell)fn);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return ((AClosure)this.value.getValue()).print(sb, limit);
    }

    public static <T extends ACell> Lambda<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 2;
        Ref<AClosure<T>> function = Format.readRef(b, epos);
        epos = (int)((long)epos + function.getEncodingLength());
        Lambda<T> result = new Lambda<T>(function);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        Object fn = this.value.getValue();
        if (!(fn instanceof AClosure)) {
            throw new InvalidDataException("Lambda child must be a closure but got: " + Utils.getClassName(fn), this);
        }
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    public AClosure<T> getFunction() {
        return (AClosure)this.value.getValue();
    }

    @Override
    protected AOp<T> rebuild(Ref<ACell> newCode, Ref<AClosure<T>> newValue) {
        if (newValue == this.value) {
            return this;
        }
        return new Lambda<T>(newValue);
    }
}

