/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm.ops;

import convex.core.cvm.AFn;
import convex.core.cvm.AOp;
import convex.core.cvm.Context;
import convex.core.cvm.Ops;
import convex.core.cvm.ops.AFlatMultiOp;
import convex.core.cvm.ops.Constant;
import convex.core.cvm.ops.Lookup;
import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Lists;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.data.util.BlobBuilder;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;

public class Invoke<T extends ACell>
extends AFlatMultiOp<T> {
    protected Invoke(AVector<AOp<ACell>> ops) {
        super((byte)-37, ops);
    }

    public static <T extends ACell> Invoke<T> create(ASequence<AOp<ACell>> ops) {
        AVector<AOp<ACell>> vops = ops.toVector();
        return new Invoke<T>(vops);
    }

    public static <T extends ACell> Invoke<T> create(AOp<?> ... ops) {
        return Invoke.create(Vectors.create((ACell[])ops));
    }

    public static <T extends ACell> Invoke<T> build(Object ... vals) {
        int n = vals.length;
        AOp[] ops = new AOp[n];
        for (int i = 0; i < n; ++i) {
            Object v = RT.cvm(vals[i]);
            ops[i] = v instanceof AOp ? (Constant)v : Constant.of(v);
        }
        return Invoke.create(ops);
    }

    public static <T extends ACell, A extends AOp<ACell>, F extends AOp<ACell>> Invoke<T> create(F f, ASequence<A> args) {
        ASequence<A> nargs = args;
        AList<AOp<ACell>> ops = nargs.cons(f);
        return Invoke.create(ops);
    }

    @Override
    protected Invoke<T> recreate(AVector<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return Invoke.create(newOps);
    }

    public static <T extends ACell> Invoke<T> create(String string, AOp<?> ... args) {
        return Invoke.create(Lookup.create(string), Vectors.create((ACell[])args));
    }

    @Override
    public Context execute(Context context) {
        long n = this.ops.count();
        if (n == 0L) {
            return context.withResult(50L, Lists.empty());
        }
        AOp fnOp = Ops.castOp((ACell)this.ops.get(0));
        Context ctx = context.execute(fnOp);
        if (ctx.isExceptional()) {
            return ctx;
        }
        Object rf = ctx.getResult();
        AFn fn = RT.castFunction(rf);
        if (fn == null) {
            Context rctx = context.withCastError((ACell)rf, (AType)Types.FUNCTION);
            ctx.getError().addTrace("Trying to get function for expression: " + String.valueOf(RT.print(this)));
            return rctx;
        }
        int arity = this.ops.size() - 1;
        ACell[] args = new ACell[arity];
        for (int i = 0; i < arity; ++i) {
            AOp argOp = Ops.castOp((ACell)this.ops.get(i + 1));
            if ((ctx = ctx.execute(argOp)).isExceptional()) {
                return ctx;
            }
            args[i] = ctx.getResult();
        }
        if ((ctx = ctx.invoke(fn, args)).isError()) {
            try {
                ctx.getError().addTrace("In expression: " + String.valueOf(RT.print(this)));
            }
            catch (Exception e) {
                ctx.getError().addTrace("TRACE FAILED");
            }
        }
        return ctx;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append('(');
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            AOp op;
            if (i > 0) {
                bb.append(' ');
            }
            if ((op = Ops.castOp((ACell)this.ops.get(i))).print(bb, limit)) continue;
            return false;
        }
        bb.append(')');
        return bb.check(limit);
    }

    public static <T extends ACell> Invoke<T> read(Blob b, int pos) throws BadFormatException {
        int epos = pos;
        AVector<AOp<ACell>> ops = Vectors.read(b, epos);
        Invoke<T> result = Invoke.create(ops);
        result.attachEncoding(b.slice(pos, epos += Cells.getEncodingLength(ops)));
        return result;
    }
}

