/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.cvm.ARecordGeneric;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.RecordFormat;
import convex.core.cvm.State;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AIndex;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Index;
import convex.core.data.Keyword;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.util.Utils;

public class PeerStatus
extends ARecordGeneric {
    private static final Keyword[] PEER_KEYS = new Keyword[]{Keywords.CONTROLLER, Keywords.STAKE, Keywords.STAKES, Keywords.DELEGATED_STAKE, Keywords.METADATA, Keywords.TIMESTAMP, Keywords.BALANCE};
    private static final RecordFormat FORMAT = RecordFormat.of(PEER_KEYS);
    private static final Index<Address, CVMLong> EMPTY_STAKES = Index.none();
    private final int IX_TIMESTAMP = 5;
    private final Address controller;
    private final long peerStake;
    private Index<Address, CVMLong> stakes;
    private final long delegatedStake;
    private AHashMap<ACell, ACell> metadata;
    private final long timestamp;
    private final long balance;

    private PeerStatus(Address controller, long stake, Index<Address, CVMLong> stakes, long delegatedStake, AHashMap<ACell, ACell> metadata, long timestamp, long balance) {
        super((byte)-39, FORMAT, Vectors.create(controller, CVMLong.create(stake), stakes, CVMLong.create(delegatedStake), metadata, CVMLong.create(timestamp), CVMLong.create(balance)));
        this.controller = controller;
        this.peerStake = stake;
        this.stakes = stakes;
        this.delegatedStake = delegatedStake;
        this.metadata = metadata;
        this.timestamp = timestamp;
        this.balance = balance;
    }

    public PeerStatus(AVector<ACell> values) {
        super((byte)-39, FORMAT, values);
        this.controller = RT.ensureAddress((ACell)values.get(0));
        this.peerStake = RT.ensureLong((ACell)values.get(1)).longValue();
        this.delegatedStake = RT.ensureLong((ACell)values.get(3)).longValue();
        this.timestamp = RT.ensureLong((ACell)values.get(5)).longValue();
        this.balance = RT.ensureLong((ACell)values.get(6)).longValue();
    }

    public static PeerStatus create(Address controller, long stake) {
        return PeerStatus.create(controller, stake, null);
    }

    public static PeerStatus create(Address controller, long stake, AHashMap<ACell, ACell> metadata) {
        return new PeerStatus(controller, stake, EMPTY_STAKES, 0L, metadata, -1L, stake);
    }

    public long getTotalStake() {
        return this.peerStake + this.delegatedStake;
    }

    public long getBalance() {
        return this.balance;
    }

    public long getDelegatedStake() {
        long totalShares = this.peerStake + this.delegatedStake;
        if (totalShares <= 0L) {
            return 0L;
        }
        return Utils.mulDiv(this.balance, this.delegatedStake, totalShares);
    }

    public Index<Address, CVMLong> getStakes() {
        if (this.stakes == null) {
            this.stakes = RT.ensureIndex((ACell)this.values.get(2));
        }
        return this.stakes;
    }

    public long getPeerStake() {
        return this.balance - this.getDelegatedStake();
    }

    public long getDelegatedStake(Address delegator) {
        if (this.delegatedStake <= 0L) {
            return 0L;
        }
        Index<Address, CVMLong> stks = this.getStakes();
        if (stks == null) {
            return 0L;
        }
        CVMLong a = stks.get(delegator);
        if (a == null) {
            return 0L;
        }
        long delShares = a.longValue();
        return Utils.mulDiv(this.balance - this.getPeerStake(), delShares, this.delegatedStake);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Address getController() {
        return this.controller;
    }

    public AString getHostname() {
        AHashMap<ACell, ACell> meta = this.getMetadata();
        if (meta == null) {
            return null;
        }
        return RT.ensureString(meta.get(Keywords.URL));
    }

    public AHashMap<ACell, ACell> getMetadata() {
        if (this.metadata == null) {
            this.metadata = (AHashMap)this.values.get(4);
        }
        return this.metadata;
    }

    public static PeerStatus read(Blob b, int pos) throws BadFormatException {
        AVector<ACell> values = Vectors.read(b, pos);
        int epos = pos + values.getEncodingLength();
        PeerStatus result = new PeerStatus(values);
        result.attachEncoding(b.slice(pos, epos));
        return result;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public PeerStatus withDelegatedStake(Address delegator, long newStake) {
        AIndex newStakes;
        if (newStake < 0L) {
            throw new IllegalArgumentException("Negative peer stake!");
        }
        long oldStake = this.getDelegatedStake(delegator);
        if (oldStake == newStake) {
            return this;
        }
        long stakeChange = newStake - oldStake;
        long newDelegatedStake = this.delegatedStake + stakeChange;
        Index<Address, CVMLong> stks = this.getStakes();
        if (stks == null) {
            stks = EMPTY_STAKES;
        }
        AIndex aIndex = newStakes = newStake == 0L ? stks.dissoc((ABlobLike)delegator) : stks.assoc(delegator, CVMLong.create(newStake));
        if (newStakes.isEmpty()) {
            newStakes = null;
        }
        return new PeerStatus(this.controller, this.peerStake, (Index<Address, CVMLong>)newStakes, newDelegatedStake, this.metadata, this.timestamp, this.balance + stakeChange);
    }

    private PeerStatus withBalance(long newBalance) {
        if (this.balance == newBalance) {
            return this;
        }
        return new PeerStatus((AVector<ACell>)this.values.assoc(6L, (ACell)CVMLong.create(newBalance)));
    }

    private PeerStatus withTimestamp(long newTimestamp) {
        if (this.timestamp == newTimestamp) {
            return this;
        }
        return new PeerStatus((AVector<ACell>)this.values.assoc(5L, (ACell)CVMLong.create(newTimestamp)));
    }

    public PeerStatus withPeerStake(long newStake) {
        if (newStake < 0L) {
            throw new IllegalArgumentException("Negative peer stake!");
        }
        if (this.peerStake == newStake) {
            return this;
        }
        long stakeChange = newStake - this.peerStake;
        return new PeerStatus(this.controller, newStake, this.getStakes(), this.delegatedStake, this.getMetadata(), this.timestamp, this.balance + stakeChange);
    }

    public PeerStatus withPeerData(AHashMap<ACell, ACell> newMeta) {
        if (this.metadata == newMeta) {
            return this;
        }
        return new PeerStatus(this.controller, this.peerStake, this.getStakes(), this.delegatedStake, newMeta, this.timestamp, this.balance);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.balance < 0L) {
            throw new InvalidDataException("Negative balance?", this);
        }
        if (this.delegatedStake < 0L) {
            throw new InvalidDataException("Negative delegated stake?", this);
        }
        if (this.peerStake < 0L) {
            throw new InvalidDataException("Negative peer stake?", this);
        }
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.CONTROLLER.equals(key)) {
            return this.controller;
        }
        if (Keywords.STAKE.equals(key)) {
            return this.values.get(1);
        }
        if (Keywords.STAKES.equals(key)) {
            return this.getStakes();
        }
        if (Keywords.DELEGATED_STAKE.equals(key)) {
            return this.values.get(3);
        }
        if (Keywords.METADATA.equals(key)) {
            return this.getMetadata();
        }
        if (Keywords.TIMESTAMP.equals(key)) {
            return this.values.get(5);
        }
        if (Keywords.BALANCE.equals(key)) {
            return this.values.get(6);
        }
        return null;
    }

    protected static long computeDelegatedStake(Index<Address, CVMLong> stks) {
        long ds = stks.reduceValues((acc, e) -> acc + e.longValue(), 0L);
        return ds;
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof PeerStatus) {
            return this.equals((PeerStatus)a);
        }
        return Cells.equalsGeneric(this, a);
    }

    public boolean equals(PeerStatus a) {
        if (this == a) {
            return true;
        }
        return Cells.equalsGeneric(a, a);
    }

    public PeerStatus addReward(long peerFees) {
        if (peerFees < 0L) {
            throw new IllegalArgumentException("Negative fees!");
        }
        return this.withBalance(this.balance + peerFees);
    }

    @Override
    protected ARecordGeneric withValues(AVector<ACell> newValues) {
        if (this.values == newValues) {
            return this;
        }
        return new PeerStatus(newValues);
    }

    public PeerStatus distributeBlockReward(State state, long peerFees, long newBlockTime) {
        PeerStatus ps = this.addReward(peerFees);
        long oldTime = ps.getTimestamp();
        if (oldTime < newBlockTime) {
            ps = ps.withTimestamp(newBlockTime);
        }
        return ps;
    }
}

