/*
 * Decompiled with CFR 0.152.
 */
package convex.core.cvm;

import convex.core.cvm.Address;
import convex.core.cvm.State;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.CAD3Encoder;
import convex.core.data.ExtensionValue;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.Core;

public class CVMEncoder
extends CAD3Encoder {
    public static final CVMEncoder INSTANCE = new CVMEncoder();

    @Override
    public ACell read(Blob encoding, int offset) throws BadFormatException {
        return super.read(encoding, offset);
    }

    @Override
    protected ACell readExtension(byte tag, Blob blob, int offset) throws BadFormatException {
        ACell cc;
        long code = Format.readVLQCount(blob, offset + 1);
        if (tag == -19 && (cc = Core.fromCode(code)) != null) {
            return cc;
        }
        if (tag == -22) {
            return Address.create(code);
        }
        return ExtensionValue.create(tag, code);
    }

    @Override
    protected ACell readDenseRecord(byte tag, Blob encoding, int offset) throws BadFormatException {
        switch (tag) {
            case -43: {
                return State.read(encoding, offset);
            }
        }
        return super.read(tag, encoding, offset);
    }
}

