/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.wallet;

import convex.core.crypto.wallet.AWallet;
import convex.core.crypto.wallet.HotWalletEntry;
import convex.core.crypto.wallet.LockedWalletException;
import convex.core.cvm.Address;
import convex.core.data.AccountKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS12Wallet
extends AWallet {
    public static final String KEYSTORE_TYPE = "pkcs12";
    private static final Logger log = LoggerFactory.getLogger((String)PKCS12Wallet.class.getName());
    private HashMap<Address, HotWalletEntry> data;

    private PKCS12Wallet(HashMap<Address, HotWalletEntry> data) {
        this.data = data;
    }

    public static PKCS12Wallet create() {
        return new PKCS12Wallet(new HashMap<Address, HotWalletEntry>());
    }

    public HotWalletEntry get(Address a) {
        return this.data.get(a);
    }

    public static File createTempStore(String password) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            char[] pwdArray = "password".toCharArray();
            ks.load(null, pwdArray);
            File file = File.createTempFile("temp-keystore", "p12");
            file.deleteOnExit();
            try (FileOutputStream fos = new FileOutputStream(file);){
                ks.store(fos, pwdArray);
            }
            return file;
        }
        catch (IOException | GeneralSecurityException t) {
            throw new Error("Unable to create temp keystore", t);
        }
    }

    public static PKCS12Wallet load(File file, String password) {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            char[] pwdArray = password.toCharArray();
            ks.load(new FileInputStream(file), pwdArray);
            Enumeration<String> aliases = ks.aliases();
            PKCS12Wallet wallet = PKCS12Wallet.create();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                ks.getKey(alias, pwdArray);
                log.info("Loading private key with alias: " + alias);
            }
            return wallet;
        }
        catch (IOException | GeneralSecurityException t) {
            throw new Error("Unable to load keystore with file: " + String.valueOf(file), t);
        }
    }

    @Override
    public void getKeyPair(AccountKey pubKey) throws LockedWalletException {
    }
}

