/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.Ed25519Signature;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.AccountKey;
import convex.core.exceptions.BadFormatException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public abstract class ASignature
extends AArrayBlob {
    protected ASignature(byte[] signature, int pos) {
        super(signature, pos, 64);
    }

    public abstract boolean verify(AArrayBlob var1, AccountKey var2);

    public static ASignature read(ByteBuffer bb) throws BadFormatException {
        return Ed25519Signature.read(bb);
    }

    public static ASignature fromHex(String hex) {
        byte[] bs = Utils.hexToBytes(hex);
        return Ed25519Signature.wrap(bs);
    }

    public static ASignature fromBlob(ABlob sigData) {
        byte[] bs = sigData.getBytes();
        return Ed25519Signature.wrap(bs);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean equals(ABlob b) {
        return b.equalsBytes(this);
    }
}

