/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.cvm.Context;
import convex.core.cvm.Juice;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Keyword;

public class ResultContext {
    public ATransaction tx;
    public long juicePrice;
    public long memUsed = 0L;
    public Context context = null;
    public long totalFees = 0L;
    public long juiceUsed = 0L;
    public Keyword source = null;

    public ResultContext(ATransaction transaction, long juicePrice) {
        this.juicePrice = juicePrice;
        this.tx = transaction;
    }

    public ResultContext withContext(Context ctx) {
        this.context = ctx;
        return this;
    }

    public static ResultContext error(State state, Keyword error, String message) {
        ResultContext rc = new ResultContext(null, 0L);
        rc.context = Context.create(state).withError(error, message);
        return rc;
    }

    public static ResultContext error(State state, Keyword error, AString message) {
        return ResultContext.error(state, error, message.toString());
    }

    public ACell getResult() {
        return this.context.getResult();
    }

    public static ResultContext fromContext(Context ctx) {
        State state = ctx.getState();
        ResultContext rc = new ResultContext(null, state.getJuicePrice().longValue());
        rc.context = ctx;
        rc.juiceUsed = ctx.getJuiceUsed();
        return rc;
    }

    public ACell getErrorCode() {
        return this.context.getErrorCode();
    }

    public long getJuiceFees() {
        return Juice.mul(this.juiceUsed, this.juicePrice) + Juice.mul(Juice.priceTransaction(this.tx), this.juicePrice);
    }

    public long getExecutionFees() {
        return Juice.mul(this.juiceUsed, this.juicePrice);
    }

    public State getState() {
        return this.context.getState();
    }

    public long getMemoryFees() {
        return this.totalFees - this.getJuiceFees();
    }

    public boolean isError() {
        return this.context.isError();
    }

    public ResultContext withSource(Keyword sourceCode) {
        this.source = sourceCode;
        return this;
    }

    public Keyword getSource() {
        return this.source;
    }
}

