/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.lang.ops.AMultiOp;
import java.nio.ByteBuffer;

public class Cond<T extends ACell>
extends AMultiOp<T> {
    protected Cond(AVector<AOp<ACell>> ops) {
        super(ops);
    }

    public static <T extends ACell> Cond<T> create(AOp<?> ... ops) {
        AVector<AOp<ACell>> refOps = Vectors.create(ops);
        return Cond.create(refOps);
    }

    @Override
    protected Cond<T> recreate(ASequence<AOp<ACell>> newOps) {
        if (this.ops == newOps) {
            return this;
        }
        return new Cond<T>(newOps.toVector());
    }

    public static <T extends ACell> Cond<T> create(ASequence<AOp<ACell>> ops) {
        return new Cond<T>(ops.toVector());
    }

    @Override
    public <I extends ACell> Context<T> execute(Context<I> context) {
        int n = this.ops.size();
        Context ctx = context.consumeJuice(20L);
        if (ctx.isExceptional()) {
            return ctx;
        }
        for (int i = 0; i < n - 1; i += 2) {
            AOp testOp = (AOp)this.ops.get(i);
            if ((ctx = ctx.execute(testOp)).isExceptional()) {
                return ctx;
            }
            Object test = ctx.getResult();
            if (!RT.bool(test)) continue;
            return ctx.execute((AOp)this.ops.get(i + 1));
        }
        if ((n & 1) == 0) {
            return ctx.withResult(null);
        }
        return ctx.execute((AOp)this.ops.get(n - 1));
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("(cond");
        int len = this.ops.size();
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
            if (((AOp)this.ops.get(i)).print(sb, limit)) continue;
            return false;
        }
        sb.append(')');
        return sb.check(limit);
    }

    @Override
    public byte opCode() {
        return 4;
    }

    public static <T extends ACell> Cond<T> read(ByteBuffer b) throws BadFormatException {
        AVector ops = (AVector)Format.read(b);
        return Cond.create(ops);
    }

    @Override
    public Cond<T> updateRefs(IRefFunction func) {
        ACell newOps = this.ops.updateRefs(func);
        return this.recreate((ASequence)newOps);
    }
}

