/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.BlobTree;
import convex.core.data.Format;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;

public abstract class AArrayBlob
extends ABlob {
    protected final byte[] store;
    protected final int offset;
    protected final int length;

    protected AArrayBlob(byte[] bytes, int offset, int length) {
        this.store = bytes;
        this.length = length;
        this.offset = offset;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.store, this.offset, this.length);
    }

    @Override
    public AArrayBlob slice(long start, long end) {
        if (start < 0L) {
            return null;
        }
        if (end > (long)this.length) {
            return null;
        }
        long length = end - start;
        if (length < 0L) {
            return null;
        }
        if (start == 0L && end == this.count()) {
            return this;
        }
        return Blob.wrap(this.store, Utils.checkedInt(start + (long)this.offset), Utils.checkedInt(length));
    }

    @Override
    public ABlob append(ABlob d) {
        long dlength = d.count();
        if (dlength == 0L) {
            return (ABlob)this.getCanonical();
        }
        long length = this.length;
        if (length == 0L) {
            return (ABlob)d.getCanonical();
        }
        if (length > 4096L) {
            return BlobTree.create(this).append(d);
        }
        long newLen = length + dlength;
        if (newLen <= 4096L) {
            return this.appendSmall(d);
        }
        if (newLen <= 8192L) {
            long split = 4096L - length;
            return BlobTree.create(this.append(d.slice(0L, split)).toFlatBlob(), d.slice(split, dlength).toFlatBlob());
        }
        BlobBuilder bb = new BlobBuilder(this);
        bb.append(d);
        return bb.toBlob();
    }

    protected ABlob appendSmall(ABlob d) {
        int n = Utils.checkedInt(this.count() + d.count());
        if (n > 4096) {
            throw new Error("Illegal Blob appendSmall size: " + n);
        }
        byte[] newData = new byte[n];
        this.getBytes(newData, 0);
        d.getBytes(newData, this.length);
        return Blob.wrap(newData);
    }

    @Override
    public Blob toFlatBlob() {
        return Blob.wrap(this.store, this.offset, this.length);
    }

    @Override
    public final int compareTo(ABlob b) {
        if (b instanceof AArrayBlob) {
            return this.compareTo((AArrayBlob)b);
        }
        return this.compareTo(b.toFlatBlob());
    }

    @Override
    public final int compareTo(AArrayBlob b) {
        if (this == b) {
            return 0;
        }
        int alength = this.length;
        int blength = b.length;
        int compareLength = Math.min(alength, blength);
        int c = Utils.compareByteArrays(this.store, this.offset, b.store, b.offset, compareLength);
        if (c != 0) {
            return c;
        }
        if (alength > compareLength) {
            return 1;
        }
        if (blength > compareLength) {
            return -1;
        }
        return 0;
    }

    @Override
    public final void getBytes(byte[] dest, int destOffset) {
        System.arraycopy(this.store, this.offset, dest, destOffset, this.length);
    }

    @Override
    public ByteBuffer writeToBuffer(ByteBuffer bb) {
        return bb.put(this.store, this.offset, this.length);
    }

    @Override
    public int writeToBuffer(byte[] bs, int pos) {
        System.arraycopy(this.store, this.offset, bs, pos, this.length);
        return Utils.checkedInt(pos + this.length);
    }

    @Override
    public final int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.length);
        return this.encodeRawData(bs, pos);
    }

    @Override
    public int encodeRawData(byte[] bs, int pos) {
        System.arraycopy(this.store, this.offset, bs, pos, this.length);
        return pos + this.length;
    }

    @Override
    public final boolean appendHex(BlobBuilder bb, long hexLength) {
        if (hexLength < 0L) {
            return false;
        }
        long nbytes = Math.min(hexLength / 2L, (long)this.length);
        for (long i = 0L; i < nbytes; ++i) {
            byte b = this.byteAt(i);
            Utils.appendHexByte(bb, b);
        }
        return nbytes == (long)this.length;
    }

    @Override
    public final long count() {
        return this.length;
    }

    @Override
    public final byte byteAt(long i) {
        int ix = (int)i;
        if ((long)ix != i || ix < 0 || ix >= this.length) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.store[this.offset + ix];
    }

    @Override
    public final byte getUnchecked(long i) {
        int ix = (int)i;
        return this.store[this.offset + ix];
    }

    @Override
    public int getHexDigit(long digitPos) {
        byte b = this.store[this.offset + (int)(digitPos >> 1)];
        int shift = 4 - (((int)digitPos & 1) << 2);
        return b >> shift & 0xF;
    }

    public byte[] getInternalArray() {
        return this.store;
    }

    public int getInternalOffset() {
        return this.offset;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.store, this.offset, this.length).asReadOnlyBuffer();
    }

    @Override
    public boolean equals(ABlob o) {
        if (o == null) {
            return false;
        }
        if (o.getType() != Types.BLOB) {
            return false;
        }
        if (o.count() != (long)this.length) {
            return false;
        }
        return o.equalsBytes(this.store, this.offset);
    }

    @Override
    public boolean equalsBytes(byte[] bytes, int byteOffset) {
        return Utils.arrayEquals(this.store, this.offset, bytes, byteOffset, this.length);
    }

    @Override
    public boolean equalsBytes(ABlob k) {
        if (k.count() != this.count()) {
            return false;
        }
        return k.equalsBytes(this.store, this.offset);
    }

    public boolean rangeMatches(ABlob b, int start, int end) {
        if (b instanceof AArrayBlob) {
            return this.rangeMatches((AArrayBlob)b, start, end);
        }
        for (int i = start; i < end; ++i) {
            if (this.store[this.offset + i] == b.getUnchecked(i)) continue;
            return false;
        }
        return true;
    }

    public boolean rangeMatches(AArrayBlob b, int start, int end) {
        return Arrays.equals(this.store, this.offset + start, this.offset + end, b.store, b.offset + start, b.offset + end);
    }

    @Override
    public long hexMatchLength(ABlob b, long start, long length) {
        if (b == this) {
            return length;
        }
        long end = start + length;
        for (long i = start; i < end; ++i) {
            if (this.getHexDigit(i) == b.getHexDigit(i)) continue;
            return i - start;
        }
        return length;
    }

    public boolean hexMatches(ABlob key, int start, int end) {
        if (key == this) {
            return true;
        }
        if (start == end) {
            return true;
        }
        if ((start & 1) != 0 && key.getHexDigit(start) != this.getHexDigit(start)) {
            return false;
        }
        if ((end & 1) != 0 && key.getHexDigit(end - 1) != this.getHexDigit(end - 1)) {
            return false;
        }
        return this.rangeMatches(key, start + 1 >> 1, end >> 1);
    }

    @Override
    public long commonHexPrefixLength(ABlob b) {
        if (b == this) {
            return this.count() * 2L;
        }
        long max = Math.min(this.count(), b.count());
        for (long i = 0L; i < max; ++i) {
            byte bi;
            byte ai = this.getUnchecked(i);
            if (ai == (bi = b.getUnchecked(i))) continue;
            return i * 2L + (long)(Utils.firstDigitMatch(ai, bi) ? 1 : 0);
        }
        return max * 2L;
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length < 0) {
            throw new InvalidDataException("Negative length: " + this.length, this);
        }
        if (this.offset < 0) {
            throw new InvalidDataException("Negative data offset: " + this.offset, this);
        }
        if (this.offset + this.length > this.store.length) {
            throw new InvalidDataException("End out of range: " + (this.offset + this.length) + " with array size=" + this.store.length, this);
        }
    }

    @Override
    public long longValue() {
        if (this.length != 8) {
            throw new IllegalStateException(Errors.wrongLength(8L, this.length));
        }
        return Utils.readLong(this.store, this.offset);
    }

    @Override
    public long toLong() {
        if (this.length >= 8) {
            return Utils.readLong(this.store, this.offset + this.length - 8);
        }
        long result = 0L;
        int ix = this.offset;
        if ((this.length & 4) != 0) {
            result += 0xFFFFFFFFL & (long)Utils.readInt(this.store, ix);
            ix += 4;
        }
        if ((this.length & 2) != 0) {
            result = (result << 16) + (long)(0xFFFF & Utils.readShort(this.store, ix));
            ix += 2;
        }
        if ((this.length & 1) != 0) {
            result = (result << 8) + (long)(0xFF & this.store[ix]);
            ++ix;
        }
        return result;
    }

    @Override
    public final byte getTag() {
        return 49;
    }

    @Override
    public final int getRefCount() {
        return 0;
    }
}

