/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang;

import convex.core.data.ACell;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.AOp;
import convex.core.lang.ops.Cond;
import convex.core.lang.ops.Constant;
import convex.core.lang.ops.Def;
import convex.core.lang.ops.Do;
import convex.core.lang.ops.Invoke;
import convex.core.lang.ops.Lambda;
import convex.core.lang.ops.Let;
import convex.core.lang.ops.Local;
import convex.core.lang.ops.Lookup;
import convex.core.lang.ops.Query;
import convex.core.lang.ops.Special;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Ops {
    public static final byte CONSTANT = 1;
    public static final byte INVOKE = 2;
    public static final byte DO = 3;
    public static final byte COND = 4;
    public static final byte LOOKUP = 5;
    public static final byte DEF = 6;
    public static final byte LAMBDA = 7;
    public static final byte LET = 8;
    public static final byte QUERY = 9;
    public static final byte LOOP = 10;
    public static final byte LOCAL = 11;
    public static final byte SET = 12;
    public static final byte SPECIAL_BASE = 64;

    public static <T extends ACell> AOp<T> read(ByteBuffer bb) throws BadFormatException {
        byte opCode = bb.get();
        switch (opCode) {
            case 2: {
                return Invoke.read(bb);
            }
            case 4: {
                return Cond.read(bb);
            }
            case 1: {
                return Constant.read(bb);
            }
            case 6: {
                return Def.read(bb);
            }
            case 3: {
                return Do.read(bb);
            }
            case 5: {
                return Lookup.read(bb);
            }
            case 7: {
                return Lambda.read(bb);
            }
            case 8: {
                return Let.read(bb, false);
            }
            case 9: {
                return Query.read(bb);
            }
            case 10: {
                return Let.read(bb, true);
            }
            case 11: {
                return Local.read(bb);
            }
        }
        if ((opCode & 0xC0) == 64) {
            Special<?> special = Special.create(opCode);
            if (special == null) {
                throw new BadFormatException("Bad OpCode for Special value: " + Utils.toHexString(opCode));
            }
            return special;
        }
        throw new BadFormatException("Invalide OpCode: " + opCode);
    }
}

