/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.ADataStructure;
import convex.core.data.AList;
import convex.core.data.ASequence;
import convex.core.data.BlobBuilder;
import convex.core.data.IRefFunction;
import convex.core.data.List;
import convex.core.data.Lists;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.lang.RT;
import convex.core.util.MergeFunction;
import convex.core.util.Utils;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AVector<T extends ACell>
extends ASequence<T> {
    public AVector(long count) {
        super(count);
    }

    @Override
    public AType getType() {
        return Types.VECTOR;
    }

    @Override
    public abstract T get(long var1);

    public abstract AVector<T> appendChunk(VectorLeaf<T> var1);

    public abstract VectorLeaf<T> getChunk(long var1);

    public abstract AVector<T> append(T var1);

    public abstract boolean isFullyPacked();

    public boolean isPacked() {
        return (this.count & 0xFL) == 0L;
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append('[');
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            if (RT.print(sb, (ACell)this.get(i), limit)) continue;
            return false;
        }
        sb.append(']');
        return sb.check(limit);
    }

    @Override
    public T get(int index) {
        return this.get((long)index);
    }

    public abstract boolean anyMatch(Predicate<? super T> var1);

    public abstract boolean allMatch(Predicate<? super T> var1);

    @Override
    public abstract <R extends ACell> AVector<R> map(Function<? super T, ? extends R> var1);

    @Override
    public <R extends ACell> AVector<R> flatMap(Function<? super T, ? extends ASequence<R>> mapper) {
        ASequence vals = this.map(mapper);
        ADataStructure result = this.empty();
        for (ASequence seq : vals) {
            result = ((AVector)result).concat(seq);
        }
        return result;
    }

    @Override
    public abstract <R extends ACell> AVector<R> concat(ASequence<R> var1);

    public abstract <R> R reduce(BiFunction<? super R, ? super T, ? extends R> var1, R var2);

    @Override
    public Spliterator<T> spliterator() {
        return this.spliterator(0L);
    }

    public abstract Spliterator<T> spliterator(long var1);

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        int s = this.size();
        Object[] result = new Object[s];
        this.copyToArray(result, 0);
        return result;
    }

    @Override
    public final int indexOf(Object o) {
        return Utils.checkedInt(this.longIndexOf(o));
    }

    @Override
    public final int lastIndexOf(Object o) {
        return Utils.checkedInt(this.longLastIndexOf(o));
    }

    @Override
    public final ListIterator<T> listIterator(int index) {
        return this.listIterator((long)index);
    }

    @Override
    public abstract ListIterator<T> listIterator(long var1);

    @Override
    public abstract boolean isCanonical();

    @Override
    public abstract AVector<T> updateRefs(IRefFunction var1);

    public abstract long commonPrefixLength(AVector<T> var1);

    public AVector<T> appendAll(java.util.List<T> list) {
        AVector<ACell> result = this;
        for (ACell value : list) {
            result = result.append(value);
        }
        return result;
    }

    @Override
    public final <R extends ACell> AVector<R> conj(R value) {
        return this.append(value);
    }

    @Override
    public <R extends ACell> AVector<R> conjAll(ACollection<R> xs) {
        if (xs instanceof ASequence) {
            return this.concat((ASequence)xs);
        }
        return this.concat((ASequence)Vectors.create(xs));
    }

    @Override
    public AList<T> cons(T x) {
        return ((AList)Lists.create(this)).cons(x);
    }

    @Override
    public abstract AVector<T> next();

    @Override
    public final AVector<T> slice(long start, long end) {
        return this.subVector(start, end - start);
    }

    @Override
    public abstract <R extends ACell> AVector<R> assoc(long var1, R var3);

    @Override
    public AVector<T> empty() {
        return Vectors.empty();
    }

    @Override
    public AList<T> reverse() {
        return List.reverse(this);
    }

    public AVector<T> mergeWith(AVector<T> b, MergeFunction<T> func) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getTag() {
        return -128;
    }

    @Override
    public abstract int encodeRaw(byte[] var1, int var2);
}

