/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.Constants;
import convex.core.data.ACell;
import convex.core.data.ACollection;
import convex.core.data.AVector;
import convex.core.data.BlobBuilder;
import convex.core.data.Hash;
import convex.core.data.IAssociative;
import convex.core.data.Ref;
import convex.core.data.Sets;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMBool;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.util.Set;
import java.util.function.Function;

public abstract class ASet<T extends ACell>
extends ACollection<T>
implements Set<T>,
IAssociative<T, CVMBool> {
    protected ASet(long count) {
        super(count);
    }

    @Override
    public final AType getType() {
        return Types.SET;
    }

    @Override
    public final byte getTag() {
        return -125;
    }

    public abstract <R extends ACell> ASet<R> include(R var1);

    public abstract ASet<T> exclude(T var1);

    public abstract <R extends ACell> ASet<R> includeAll(ASet<R> var1);

    public abstract ASet<T> excludeAll(ASet<T> var1);

    @Override
    public abstract <R extends ACell> ASet<R> conjAll(ACollection<R> var1);

    public abstract ASet<T> disjAll(ACollection<T> var1);

    @Override
    public <R extends ACell> AVector<R> toVector() {
        int n = Utils.checkedInt(this.count);
        ACell[] elements = new ACell[n];
        this.copyToArray(elements, 0);
        return Vectors.create(elements);
    }

    @Override
    public <R extends ACell> ASet<R> map(Function<? super T, ? extends R> mapper) {
        ACollection result = Sets.empty();
        for (long i = 0L; i < this.count; ++i) {
            result = ((ASet)result).conj((ACell)mapper.apply(this.get(i)));
        }
        return result;
    }

    public abstract ASet<T> intersectAll(ASet<T> var1);

    @Override
    public CVMBool get(ACell key) {
        return this.contains(key) ? Constants.SET_INCLUDED : Constants.SET_EXCLUDED;
    }

    @Override
    public ACell get(ACell key, ACell notFound) {
        if (this.contains(key)) {
            return Constants.SET_INCLUDED;
        }
        return notFound;
    }

    @Override
    public T get(long index) {
        return (T)this.getElementRef(index).getValue();
    }

    public abstract boolean contains(ACell var1);

    @Override
    public final boolean contains(Object o) {
        if (o == null || o instanceof ACell) {
            return this.contains((ACell)o);
        }
        return false;
    }

    public abstract ASet<T> includeRef(Ref<T> var1);

    @Override
    public abstract <R extends ACell> ASet<R> conj(R var1);

    @Override
    public ASet<T> assoc(ACell key, ACell value) {
        if (value == CVMBool.TRUE) {
            return this.include(key);
        }
        if (value == CVMBool.FALSE) {
            return this.exclude(key);
        }
        return null;
    }

    @Override
    public boolean containsKey(ACell key) {
        return this.contains(key);
    }

    @Override
    public ASet<T> empty() {
        return Sets.empty();
    }

    public abstract Ref<T> getValueRef(ACell var1);

    protected abstract Ref<T> getRefByHash(Hash var1);

    @Override
    public abstract boolean containsAll(ASet<T> var1);

    public boolean isSubset(ASet<T> b) {
        return b.containsAll(this);
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        sb.append("#{");
        for (long i = 0L; i < this.count; ++i) {
            if (i > 0L) {
                sb.append(',');
            }
            if (RT.print(sb, this.get(i), limit)) continue;
            return false;
        }
        sb.append('}');
        return sb.check(limit);
    }

    @Override
    public abstract ASet<T> slice(long var1, long var3);
}

