/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.Ed25519KeyPair;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PEMTools {
    public static String writePEM(AKeyPair kp) {
        PrivateKey priv = kp.getPrivate();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(priv.getEncoded());
        byte[] encoded = keySpec.getEncoded();
        String base64 = Base64.getEncoder().encodeToString(encoded);
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PRIVATE KEY-----");
        sb.append(System.lineSeparator());
        sb.append(base64);
        sb.append(System.lineSeparator());
        sb.append("-----END PRIVATE KEY-----");
        String pem = sb.toString();
        return pem;
    }

    public static AKeyPair readPEM(String pem) throws GeneralSecurityException {
        String publicKeyPEM = pem.trim().replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
        byte[] bs = Base64.getDecoder().decode(publicKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("Ed25519");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bs);
        PrivateKey priv = keyFactory.generatePrivate(keySpec);
        PublicKey pub = keyFactory.generatePublic(keySpec);
        return Ed25519KeyPair.create(pub, priv);
    }

    public static String encryptPrivateKeyToPEM(PrivateKey privateKey, char[] password) throws Error {
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter writer = new JcaPEMWriter((Writer)stringWriter);
        JceOpenSSLPKCS8EncryptorBuilder builder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.AES_256_CBC);
        builder.setPassword(password);
        try {
            OutputEncryptor encryptor = builder.build();
            JcaPKCS8Generator generator = new JcaPKCS8Generator(privateKey, encryptor);
            writer.writeObject((PemObjectGenerator)generator);
            writer.close();
        }
        catch (IOException | OperatorCreationException e) {
            throw new Error("cannot encrypt private key to PEM: " + (Exception)e);
        }
        return stringWriter.toString();
    }

    public static PrivateKey decryptPrivateKeyFromPEM(String pemText, char[] password) throws Error {
        PrivateKey privateKey = null;
        StringReader stringReader = new StringReader(pemText);
        PEMParser pemParser = new PEMParser((Reader)stringReader);
        PemObject pemObject = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        try {
            pemObject = pemParser.readPemObject();
            while (pemObject != null && !pemObject.getType().equals("ENCRYPTED PRIVATE KEY")) {
                pemObject = pemParser.readPemObject();
            }
        }
        catch (IOException e) {
            throw new Error("cannot read PEM " + e);
        }
        if (pemObject == null) {
            throw new Error("no encrypted private key found in pem text");
        }
        try {
            PKCS8EncryptedPrivateKeyInfo encryptedInfo = new PKCS8EncryptedPrivateKeyInfo(pemObject.getContent());
            JceOpenSSLPKCS8DecryptorProviderBuilder inputBuilder = new JceOpenSSLPKCS8DecryptorProviderBuilder();
            inputBuilder.setProvider("BC");
            InputDecryptorProvider decryptor = inputBuilder.build(password);
            PrivateKeyInfo privateKeyInfo = encryptedInfo.decryptPrivateKeyInfo(decryptor);
            privateKey = converter.getPrivateKey(privateKeyInfo);
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw new Error("cannot decrypt password from PEM " + (Exception)e);
        }
        return privateKey;
    }

    public static void main(String[] args) throws Exception {
        AKeyPair kp = AKeyPair.createSeeded(1337L);
        String pem = PEMTools.writePEM(kp);
        System.out.println(pem);
        AKeyPair kp2 = PEMTools.readPEM(pem);
        System.out.println(kp2);
    }
}

