/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data.prim;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.BlobBuilder;
import convex.core.data.INumeric;
import convex.core.data.Strings;
import convex.core.data.prim.APrimitive;
import convex.core.data.prim.CVMLong;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;

public final class CVMDouble
extends APrimitive
implements INumeric {
    public static final CVMDouble ZERO = CVMDouble.create(0.0);
    public static final CVMDouble NEGATIVE_ZERO = CVMDouble.create(-0.0);
    public static final CVMDouble ONE = CVMDouble.create(1.0);
    public static final CVMDouble MINUS_ONE = CVMDouble.create(-1.0);
    public static final CVMDouble NaN = CVMDouble.create(Double.NaN);
    public static final CVMDouble POSITIVE_INFINITY = CVMDouble.create(Double.POSITIVE_INFINITY);
    public static final CVMDouble NEGATIVE_INFINITY = CVMDouble.create(Double.NEGATIVE_INFINITY);
    private final double value;
    private static final long RAW_NAN_BITS = 9221120237041090560L;
    public static final int MAX_ENCODING_LENGTH = 9;

    public CVMDouble(double value) {
        this.value = value;
    }

    public static CVMDouble create(double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        return new CVMDouble(value);
    }

    @Override
    public AType getType() {
        return Types.DOUBLE;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public CVMLong toLong() {
        return CVMLong.create(this.longValue());
    }

    @Override
    public CVMDouble toDouble() {
        return this;
    }

    @Override
    public CVMDouble signum() {
        if (this.value > 0.0) {
            return ONE;
        }
        if (this.value < 0.0) {
            return MINUS_ONE;
        }
        if (Double.isNaN(this.value)) {
            return NaN;
        }
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        return 9;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (Double.isNaN(this.value) && this.value != Double.NaN) {
            throw new InvalidDataException("Non-canonical NaN value", this);
        }
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 13;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        long doubleBits = Double.doubleToRawLongBits(this.value);
        return Utils.writeLong(bs, pos, doubleBits);
    }

    @Override
    public String toString() {
        if (Double.isInfinite(this.value)) {
            if (this.value > 0.0) {
                return "##Inf";
            }
            return "##-Inf";
        }
        if (Double.isNaN(this.value)) {
            return "##NaN";
        }
        return Double.toString(this.value);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.toString());
        return bb.count() <= limit;
    }

    @Override
    public Class<?> numericType() {
        return Double.class;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public static CVMDouble parse(String s) {
        return CVMDouble.create(Double.parseDouble(s));
    }

    @Override
    public byte getTag() {
        return 13;
    }

    @Override
    public INumeric toStandardNumber() {
        return this;
    }

    public static CVMDouble read(double value) throws BadFormatException {
        if (Double.isNaN(value) && Double.doubleToRawLongBits(value) != 9221120237041090560L) {
            throw new BadFormatException("Non-canonical NaN value");
        }
        return CVMDouble.create(value);
    }

    @Override
    public AString toCVMString(long limit) {
        if (limit < 1L) {
            return null;
        }
        return Strings.create(this.toString());
    }

    @Override
    public boolean equals(ACell a) {
        return a instanceof CVMDouble && Double.compare(((CVMDouble)a).value, this.value) == 0;
    }
}

