/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.store.BlobCache;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class AStore {
    protected final BlobCache blobCache = BlobCache.create(100000);

    public abstract <T extends ACell> Ref<T> storeRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3);

    public abstract <T extends ACell> Ref<T> storeTopRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3);

    public abstract <T extends ACell> Ref<T> refForHash(Hash var1);

    public abstract Hash getRootHash() throws IOException;

    public abstract void setRootHash(Hash var1) throws IOException;

    public abstract void close();

    public final ACell decode(ABlob encoding) throws BadFormatException {
        ACell cached = this.blobCache.getCell(encoding);
        if (cached != null) {
            return cached;
        }
        Object decoded = Format.read(encoding.toFlatBlob());
        if (decoded == null) {
            return decoded;
        }
        assert (((ACell)decoded).cachedEncoding() != null);
        this.blobCache.putCell((ACell)decoded);
        return decoded;
    }
}

