/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.VectorLeaf;
import convex.core.data.VectorTree;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.bouncycastle.util.Arrays;

public class Vectors {
    protected static final int BITS_PER_LEVEL = 4;
    protected static final int CHUNK_SIZE = 16;
    protected static final int BITMASK = 15;
    public static final int MAX_ENCODING_LENGTH = Math.max(2391, VectorTree.MAX_ENCODING_LENGTH);

    public static <T extends ACell> AVector<T> create(ACell[] elements, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot create vector of negative length!");
        }
        if (length <= 16) {
            return VectorLeaf.create(elements, offset, length);
        }
        int tailLength = Utils.checkedInt(length >> 4 << 4);
        AVector<T> tail = Vectors.createChunked(elements, offset, tailLength);
        if (tail.count() == (long)length) {
            return tail;
        }
        return VectorLeaf.create(elements, offset + tailLength, length - tailLength, tail);
    }

    static <T extends ACell> AVector<T> createChunked(ACell[] elements, int offset, int length) {
        if (length == 0 || (length & 0xF) != 0) {
            throw new IllegalArgumentException("Invalid vector length: " + length);
        }
        if (length == 16) {
            return VectorLeaf.create(elements, offset, length);
        }
        return VectorTree.create(elements, offset, length);
    }

    public static <T extends ACell> AVector<T> create(ACell[] elements) {
        return Vectors.create(elements, 0, elements.length);
    }

    public static <R extends ACell, T extends ACell> AVector<R> create(Collection<?> elements) {
        if (elements instanceof ASequence) {
            return Vectors.create((ASequence)elements);
        }
        if (elements.size() == 0) {
            return Vectors.empty();
        }
        ACell[] cells = Utils.toCellArray(elements.toArray());
        return Vectors.create(cells);
    }

    public static <R extends ACell, T extends ACell> AVector<R> create(ASequence<R> list) {
        if (list instanceof AVector) {
            return (AVector)list;
        }
        if (list.size() == 0) {
            return Vectors.empty();
        }
        return Vectors.create(list.toCellArray());
    }

    public static <T extends ACell> AVector<T> empty() {
        return VectorLeaf.EMPTY;
    }

    @SafeVarargs
    public static <T extends ACell> AVector<T> of(Object ... elements) {
        int n = elements.length;
        ACell[] es = new ACell[n];
        for (int i = 0; i < n; ++i) {
            Object v = elements[i];
            es[i] = RT.cvm(v);
        }
        return Vectors.create(es, 0, n);
    }

    public static <T extends ACell> AVector<T> repeat(T m, int count) {
        Object[] obs = new ACell[count];
        Arrays.fill((Object[])obs, m);
        return Vectors.create((ACell[])obs);
    }

    public static <T extends ACell> AVector<T> read(ByteBuffer bb) throws BadFormatException {
        long count = Format.readVLCLong(bb);
        if (count <= 16L || (count & 0xFL) != 0L) {
            return VectorLeaf.read(bb, count);
        }
        return VectorTree.read(bb, count);
    }
}

