/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.ARecord;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public final class Block
extends ARecord {
    private final long timestamp;
    private final AVector<SignedData<ATransaction>> transactions;
    private static final Keyword[] BLOCK_KEYS = new Keyword[]{Keywords.TIMESTAMP, Keywords.TRANSACTIONS};
    private static final RecordFormat FORMAT = RecordFormat.of(BLOCK_KEYS);
    static final Comparator<SignedData<Block>> TIMESTAMP_COMPARATOR = new Comparator<SignedData<Block>>(){

        @Override
        public int compare(SignedData<Block> a, SignedData<Block> b) {
            int sig = Long.compare(a.getValue().getTimeStamp(), b.getValue().getTimeStamp());
            return sig;
        }
    };

    private Block(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        super(FORMAT);
        this.timestamp = timestamp;
        this.transactions = transactions;
    }

    @Override
    public ACell get(ACell k) {
        if (Keywords.TIMESTAMP.equals(k)) {
            return CVMLong.create(this.timestamp);
        }
        if (Keywords.TRANSACTIONS.equals(k)) {
            return this.transactions;
        }
        return null;
    }

    @Override
    protected Block updateAll(ACell[] newVals) {
        long newTimestamp = RT.ensureLong(newVals[0]).longValue();
        AVector newTransactions = (AVector)newVals[1];
        if (this.transactions == newTransactions && this.timestamp == newTimestamp) {
            return this;
        }
        return new Block(newTimestamp, newTransactions);
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public static Block create(long timestamp, List<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, Vectors.create(transactions));
    }

    public static Block create(long timestamp, AVector<SignedData<ATransaction>> transactions) {
        return new Block(timestamp, transactions);
    }

    @SafeVarargs
    public static Block of(long timestamp, SignedData<ATransaction> ... transactions) {
        return new Block(timestamp, Vectors.of(transactions));
    }

    public int length() {
        return Utils.checkedInt(this.transactions.count());
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = this.getTag();
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Utils.writeLong(bs, pos, this.timestamp);
        pos = this.transactions.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + this.transactions.estimatedEncodingSize() + 32;
    }

    public static Block read(ByteBuffer bb) throws BadFormatException {
        long timestamp = Format.readLong(bb);
        try {
            AVector transactions = (AVector)Format.read(bb);
            if (transactions == null) {
                throw new BadFormatException("Null transactions");
            }
            return Block.create(timestamp, transactions);
        }
        catch (ClassCastException e) {
            throw new BadFormatException("Error reading Block format", e);
        }
    }

    public AVector<SignedData<ATransaction>> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isCanonical() {
        return this.transactions.isCanonical();
    }

    @Override
    public byte getTag() {
        return -85;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.transactions.validateCell();
    }

    @Override
    public boolean equals(AMap<Keyword, ACell> a) {
        if (!(a instanceof Block)) {
            return false;
        }
        return this.equals((Block)a);
    }

    public boolean equals(Block a) {
        Hash ha;
        if (a == null) {
            return false;
        }
        if (this.timestamp != a.timestamp) {
            return false;
        }
        Hash h = this.cachedHash();
        if (h != null && (ha = a.cachedHash()) != null) {
            return Utils.equals(h, ha);
        }
        return Utils.equals(this.transactions, a.transactions);
    }
}

