/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.reader;

import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AList;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Keyword;
import convex.core.data.Lists;
import convex.core.data.Maps;
import convex.core.data.Sets;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Syntax;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMChar;
import convex.core.data.prim.CVMDouble;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.ParseException;
import convex.core.lang.RT;
import convex.core.lang.Symbols;
import convex.core.lang.reader.ReaderUtils;
import convex.core.lang.reader.antlr.ConvexLexer;
import convex.core.lang.reader.antlr.ConvexListener;
import convex.core.lang.reader.antlr.ConvexParser;
import convex.core.util.Utils;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

public class AntlrReader {
    public static ACell read(String s) {
        return AntlrReader.read((CharStream)CharStreams.fromString((String)s));
    }

    public static ACell read(Reader r) throws IOException {
        return AntlrReader.read((CharStream)CharStreams.fromReader((Reader)r));
    }

    public static ACell read(CharStream cs) {
        ConvexLexer lexer = new ConvexLexer(cs);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ConvexParser parser = new ConvexParser((TokenStream)tokens);
        parser.removeErrorListeners();
        ConvexParser.SingleFormContext tree = parser.singleForm();
        CRListener visitor = new CRListener();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)visitor, (ParseTree)tree);
        ArrayList<ACell> top = visitor.popList();
        if (top.size() != 1) {
            throw new ParseException("Bad parse output: " + top);
        }
        return top.get(0);
    }

    public static AList<ACell> readAll(String source) {
        return AntlrReader.readAll((CharStream)CharStreams.fromString((String)source));
    }

    public static AList<ACell> readAll(CharStream cs) {
        ConvexLexer lexer = new ConvexLexer(cs);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ConvexParser parser = new ConvexParser((TokenStream)tokens);
        parser.removeErrorListeners();
        ConvexParser.FormsContext tree = parser.forms();
        CRListener visitor = new CRListener();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)visitor, (ParseTree)tree);
        ArrayList<ACell> top = visitor.popList();
        return Lists.create(top);
    }

    public static class CRListener
    implements ConvexListener {
        ArrayList<ArrayList<ACell>> stack = new ArrayList();

        public CRListener() {
            this.stack.add(new ArrayList());
        }

        public void push(ACell a) {
            int n = this.stack.size() - 1;
            ArrayList<ACell> top = this.stack.get(n);
            top.add(a);
        }

        public ACell pop() {
            int n = this.stack.size() - 1;
            ArrayList<ACell> top = this.stack.get(n);
            int c = top.size() - 1;
            ACell cell = top.get(c);
            top.remove(c);
            return cell;
        }

        private void pushList() {
            this.stack.add(new ArrayList());
        }

        public ArrayList<ACell> popList() {
            int n = this.stack.size() - 1;
            ArrayList<ACell> top = this.stack.get(n);
            this.stack.remove(n);
            return top;
        }

        public void visitTerminal(TerminalNode node) {
        }

        public void visitErrorNode(ErrorNode node) {
            throw new ParseException(node.getSourceInterval() + " " + node.getText());
        }

        public void enterEveryRule(ParserRuleContext ctx) {
        }

        public void exitEveryRule(ParserRuleContext ctx) {
        }

        @Override
        public void enterForm(ConvexParser.FormContext ctx) {
        }

        @Override
        public void exitForm(ConvexParser.FormContext ctx) {
        }

        @Override
        public void enterForms(ConvexParser.FormsContext ctx) {
            this.pushList();
        }

        @Override
        public void exitForms(ConvexParser.FormsContext ctx) {
        }

        @Override
        public void enterDataStructure(ConvexParser.DataStructureContext ctx) {
        }

        @Override
        public void exitDataStructure(ConvexParser.DataStructureContext ctx) {
        }

        @Override
        public void enterList(ConvexParser.ListContext ctx) {
        }

        @Override
        public void exitList(ConvexParser.ListContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push((ACell)Lists.create(elements));
        }

        @Override
        public void enterVector(ConvexParser.VectorContext ctx) {
        }

        @Override
        public void exitVector(ConvexParser.VectorContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push(Vectors.create(elements));
        }

        @Override
        public void enterSet(ConvexParser.SetContext ctx) {
        }

        @Override
        public void exitSet(ConvexParser.SetContext ctx) {
            ArrayList<ACell> elements = this.popList();
            this.push(Sets.fromCollection(elements));
        }

        @Override
        public void enterMap(ConvexParser.MapContext ctx) {
        }

        @Override
        public void exitMap(ConvexParser.MapContext ctx) {
            ArrayList<ACell> elements = this.popList();
            if (Utils.isOdd(elements.size())) {
                throw new ParseException("Map requires an even number form forms.");
            }
            this.push((ACell)Maps.create(elements.toArray(new ACell[elements.size()])));
        }

        @Override
        public void enterLiteral(ConvexParser.LiteralContext ctx) {
        }

        @Override
        public void exitLiteral(ConvexParser.LiteralContext ctx) {
        }

        @Override
        public void enterLongValue(ConvexParser.LongValueContext ctx) {
        }

        @Override
        public void exitLongValue(ConvexParser.LongValueContext ctx) {
            String s = ctx.getText();
            this.push(CVMLong.parse(s));
        }

        @Override
        public void enterDoubleValue(ConvexParser.DoubleValueContext ctx) {
        }

        @Override
        public void exitDoubleValue(ConvexParser.DoubleValueContext ctx) {
            String s = ctx.getText();
            this.push(CVMDouble.parse(s));
        }

        @Override
        public void enterNil(ConvexParser.NilContext ctx) {
        }

        @Override
        public void exitNil(ConvexParser.NilContext ctx) {
            this.push(null);
        }

        @Override
        public void enterBool(ConvexParser.BoolContext ctx) {
        }

        @Override
        public void exitBool(ConvexParser.BoolContext ctx) {
            this.push(CVMBool.parse(ctx.getText()));
        }

        @Override
        public void enterCharacter(ConvexParser.CharacterContext ctx) {
        }

        @Override
        public void exitCharacter(ConvexParser.CharacterContext ctx) {
            String s = ctx.getText();
            CVMChar c = CVMChar.parse(s);
            if (c == null) {
                throw new ParseException("Bad character literal format: " + s);
            }
            this.push(c);
        }

        @Override
        public void enterKeyword(ConvexParser.KeywordContext ctx) {
        }

        @Override
        public void exitKeyword(ConvexParser.KeywordContext ctx) {
            String s = ctx.getText();
            Keyword k = Keyword.create(s.substring(1));
            if (k == null) {
                throw new ParseException("Bad keyword format: " + s);
            }
            this.push(k);
        }

        @Override
        public void enterSymbol(ConvexParser.SymbolContext ctx) {
        }

        @Override
        public void exitSymbol(ConvexParser.SymbolContext ctx) {
            String s = ctx.getText();
            Symbol sym = Symbol.create(s);
            if (sym == null) {
                throw new ParseException("Bad keyword format: " + s);
            }
            this.push(sym);
        }

        @Override
        public void enterAddress(ConvexParser.AddressContext ctx) {
        }

        @Override
        public void exitAddress(ConvexParser.AddressContext ctx) {
            String s = ctx.getText();
            this.push(Address.parse(s));
        }

        @Override
        public void enterSyntax(ConvexParser.SyntaxContext ctx) {
            this.pushList();
        }

        @Override
        public void exitSyntax(ConvexParser.SyntaxContext ctx) {
            ArrayList<ACell> elements = this.popList();
            if (elements.size() != 2) {
                throw new ParseException("Metadata requires metadata and annotated form but got:" + elements);
            }
            AHashMap<ACell, ACell> meta = ReaderUtils.interpretMetadata(elements.get(0));
            ACell value = elements.get(1);
            this.push(Syntax.create(value, meta));
        }

        @Override
        public void enterBlob(ConvexParser.BlobContext ctx) {
        }

        @Override
        public void exitBlob(ConvexParser.BlobContext ctx) {
            String s = ctx.getText();
            Blob b = Blob.fromHex(s.substring(2));
            if (b == null) {
                throw new ParseException("Invalid Blob syntax: " + s);
            }
            this.push(b);
        }

        @Override
        public void enterQuoted(ConvexParser.QuotedContext ctx) {
        }

        @Override
        public void exitQuoted(ConvexParser.QuotedContext ctx) {
            ACell form = this.pop();
            String qs = ctx.getStart().getText();
            Symbol qsym = ReaderUtils.getQuotingSymbol(qs);
            if (qsym == null) {
                throw new ParseException("Invalid quoting reader macro: " + qs);
            }
            this.push(Lists.of(qsym, form));
        }

        @Override
        public void enterString(ConvexParser.StringContext ctx) {
        }

        @Override
        public void exitString(ConvexParser.StringContext ctx) {
            String s = ctx.getText();
            int n = s.length();
            s = s.substring(1, n - 1);
            s = ReaderUtils.unescapeString(s);
            this.push(Strings.create(s));
        }

        @Override
        public void enterSpecialLiteral(ConvexParser.SpecialLiteralContext ctx) {
        }

        @Override
        public void exitSpecialLiteral(ConvexParser.SpecialLiteralContext ctx) {
            this.pop();
            String s = ctx.getText();
            ACell special = ReaderUtils.specialLiteral(s);
            if (special == null) {
                throw new ParseException("Invalid special literal: " + s);
            }
            this.push(special);
        }

        @Override
        public void enterCommented(ConvexParser.CommentedContext ctx) {
            this.pushList();
        }

        @Override
        public void exitCommented(ConvexParser.CommentedContext ctx) {
            this.popList();
        }

        @Override
        public void enterPathSymbol(ConvexParser.PathSymbolContext ctx) {
        }

        @Override
        public void exitPathSymbol(ConvexParser.PathSymbolContext ctx) {
            ACell lookup;
            String matchString = ctx.getText();
            String[] ss = matchString.split("/", -1);
            int n = ss.length;
            if (n < 2) {
                throw new ParseException("Expected followed by symbol but got: [" + matchString + "]");
            }
            ACell aCell = lookup = ss[0].startsWith("#") ? Address.parse(ss[0]) : Symbol.create(ss[0]);
            if (lookup == null) {
                throw new ParseException("Path must start with Addres or Symbol");
            }
            for (int i = 1; i < n; ++i) {
                Symbol sym;
                Object s = ss[i];
                if (((String)s).length() == 0 && i < n - 1) {
                    s = "/" + ss[++i];
                }
                if ((sym = Symbol.create((String)s)) == null) {
                    throw new ParseException("Expected path element to be a symbol but got: " + RT.getType(sym));
                }
                lookup = Lists.of(Symbols.LOOKUP, lookup, sym);
            }
            this.push(lookup);
        }

        @Override
        public void enterSingleForm(ConvexParser.SingleFormContext ctx) {
        }

        @Override
        public void exitSingleForm(ConvexParser.SingleFormContext ctx) {
        }
    }
}

