/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.BlobBuilder;
import convex.core.data.IRefFunction;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.Symbols;
import java.util.HashMap;

public class Special<T extends ACell>
extends AOp<T> {
    private final byte opCode;
    private static int NUM_SPECIALS = 14;
    private static final int BASE = 64;
    private static final int LIMIT = 64 + NUM_SPECIALS;
    private static final Symbol[] symbols = new Symbol[NUM_SPECIALS];
    private static final Special<?>[] specials = new Special[NUM_SPECIALS];
    private static final HashMap<Symbol, Integer> opcodes = new HashMap();
    private static final byte S_JUICE = 64;
    private static final byte S_CALLER = 65;
    private static final byte S_ADDRESS = 66;
    private static final byte S_MEMORY = 67;
    private static final byte S_BALANCE = 68;
    private static final byte S_ORIGIN = 69;
    private static final byte S_RESULT = 70;
    private static final byte S_TIMESTAMP = 71;
    private static final byte S_DEPTH = 72;
    private static final byte S_OFFER = 73;
    private static final byte S_STATE = 74;
    private static final byte S_HOLDINGS = 75;
    private static final byte S_SEQUENCE = 76;
    private static final byte S_KEY = 77;

    private static byte reg(byte opCode, Symbol sym) {
        int i = opCode - 64;
        Special.symbols[i] = sym;
        Special special = new Special(opCode);
        Special.specials[i] = special;
        opcodes.put(sym, Integer.valueOf(opCode));
        return opCode;
    }

    private Special(byte opCode) {
        this.opCode = opCode;
    }

    public static final Special<?> create(int opCode) {
        if (opCode < 64 || opCode > LIMIT) {
            return null;
        }
        return specials[opCode - 64];
    }

    @Override
    public <R extends ACell> Context<T> execute(Context<R> context) {
        Context<R> ctx = context;
        switch (this.opCode) {
            case 64: {
                ctx = ctx.withResult(CVMLong.create(ctx.getJuice()));
                break;
            }
            case 65: {
                ctx = ctx.withResult(ctx.getCaller());
                break;
            }
            case 66: {
                ctx = ctx.withResult(ctx.getAddress());
                break;
            }
            case 67: {
                ctx = ctx.withResult(CVMLong.create(ctx.getAccountStatus().getMemory()));
                break;
            }
            case 68: {
                ctx = ctx.withResult(CVMLong.create(ctx.getBalance()));
                break;
            }
            case 69: {
                ctx = ctx.withResult(ctx.getOrigin());
                break;
            }
            case 70: {
                break;
            }
            case 71: {
                ctx = ctx.withResult(ctx.getState().getTimeStamp());
                break;
            }
            case 72: {
                ctx = ctx.withResult(CVMLong.create(ctx.getDepth() - 1));
                break;
            }
            case 73: {
                ctx = ctx.withResult(CVMLong.create(ctx.getOffer()));
                break;
            }
            case 74: {
                ctx = ctx.withResult(ctx.getState());
                break;
            }
            case 75: {
                ctx = ctx.withResult(ctx.getHoldings());
                break;
            }
            case 76: {
                ctx = ctx.withResult(CVMLong.create(ctx.getAccountStatus().getSequence()));
                break;
            }
            case 77: {
                ctx = ctx.withResult(ctx.getAccountStatus().getAccountKey());
                break;
            }
            default: {
                throw new Error("Bad Opcode" + this.opCode);
            }
        }
        return ctx.consumeJuice(10L);
    }

    @Override
    public byte opCode() {
        return this.opCode;
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return pos;
    }

    @Override
    public Special<T> updateRefs(IRefFunction func) {
        return this;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.opCode < 64 || this.opCode >= LIMIT) {
            throw new InvalidDataException("Invalid Special opCode " + this.opCode, this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        return symbols[this.opCode - 64].print(bb, limit);
    }

    public static <R extends ACell> Special<R> forSymbol(Symbol sym) {
        Integer special = opcodes.get(sym);
        if (special == null) {
            return null;
        }
        return specials[special - 64];
    }

    static {
        Special.reg((byte)64, Symbols.STAR_JUICE);
        Special.reg((byte)65, Symbols.STAR_CALLER);
        Special.reg((byte)66, Symbols.STAR_ADDRESS);
        Special.reg((byte)67, Symbols.STAR_MEMORY);
        Special.reg((byte)68, Symbols.STAR_BALANCE);
        Special.reg((byte)69, Symbols.STAR_ORIGIN);
        Special.reg((byte)70, Symbols.STAR_RESULT);
        Special.reg((byte)71, Symbols.STAR_TIMESTAMP);
        Special.reg((byte)72, Symbols.STAR_DEPTH);
        Special.reg((byte)73, Symbols.STAR_OFFER);
        Special.reg((byte)74, Symbols.STAR_STATE);
        Special.reg((byte)75, Symbols.STAR_HOLDINGS);
        Special.reg((byte)76, Symbols.STAR_SEQUENCE);
        Special.reg((byte)77, Symbols.STAR_KEY);
    }
}

