/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.ops;

import convex.core.data.ACell;
import convex.core.data.AList;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.List;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.data.VectorLeaf;
import convex.core.data.prim.CVMBool;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.RT;
import convex.core.util.Errors;
import java.nio.ByteBuffer;

public class Constant<T extends ACell>
extends AOp<T> {
    public static final Constant<?> NULL = new Constant(Ref.NULL_VALUE);
    public static final Constant<CVMBool> TRUE = new Constant<CVMBool>(Ref.TRUE_VALUE);
    public static final Constant<CVMBool> FALSE = new Constant<CVMBool>(Ref.FALSE_VALUE);
    public static final Constant<AVector<?>> EMPTY_VECTOR = new Constant(VectorLeaf.EMPTY_REF);
    public static final Constant<AList<?>> EMPTY_LIST = new Constant(List.EMPTY_REF);
    private final Ref<T> valueRef;

    private Constant(Ref<T> valueRef) {
        this.valueRef = valueRef;
    }

    public static <T extends ACell> Constant<T> create(T value) {
        return new Constant<T>(Ref.get(value));
    }

    public static <T extends ACell> Constant<T> of(Object value) {
        return Constant.create(RT.cvm(value));
    }

    public static Constant<AString> createString(String stringValue) {
        return new Constant<AString>(Strings.create(stringValue).getRef());
    }

    public static <T extends ACell> Constant<T> createFromRef(Ref<T> valueRef) {
        if (valueRef == null) {
            throw new IllegalArgumentException("Can't create with null ref");
        }
        return new Constant<T>(valueRef);
    }

    @Override
    public <I extends ACell> Context<T> execute(Context<I> context) {
        return context.withResult(5L, this.valueRef.getValue());
    }

    @Override
    public boolean print(BlobBuilder sb, long limit) {
        return RT.print(sb, this.valueRef.getValue(), limit);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.valueRef.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 141;
    }

    public static <T extends ACell> AOp<T> read(ByteBuffer bb) throws BadFormatException {
        Ref ref = Format.readRef(bb);
        return Constant.createFromRef(ref);
    }

    @Override
    public byte opCode() {
        return 1;
    }

    @Override
    public int getRefCount() {
        return 1;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.valueRef;
    }

    @Override
    public Constant<T> updateRefs(IRefFunction func) {
        Ref<?> newRef = func.apply(this.valueRef);
        if (this.valueRef == newRef) {
            return this;
        }
        return Constant.createFromRef(newRef);
    }

    public static <T extends ACell> AOp<T> nil() {
        return NULL;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.valueRef == null) {
            throw new InvalidDataException("Missing contant value ref!", this);
        }
    }
}

