/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.BlobTree;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.Strings;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.TODOException;
import java.nio.ByteBuffer;

public class StringTree
extends AString {
    public static final int MINIMUM_LENGTH = 4097;
    public static final int MAX_ENCODING_LENGTH = 645;
    private final BlobTree data;

    private StringTree(BlobTree data) {
        super(data.count());
        this.data = data;
    }

    public static StringTree create(BlobTree b) {
        return new StringTree(b);
    }

    public static StringTree create(ABlob b) {
        return StringTree.create(BlobTree.create(b));
    }

    @Override
    public AString subSequence(long start, long end) {
        return Strings.create(this.data.slice(start, end - start));
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.data.validateCell();
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRawData(byte[] bs, int pos) {
        return this.data.encodeRawData(bs, pos);
    }

    public static StringTree read(long length, ByteBuffer bb) throws BadFormatException {
        BlobTree bt = BlobTree.read(bb, length);
        return new StringTree(bt);
    }

    @Override
    public int estimatedEncodingSize() {
        return this.data.estimatedEncodingSize();
    }

    @Override
    public boolean isCanonical() {
        return this.data.isCanonical();
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int getRefCount() {
        return this.data.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return this.data.getRef(i);
    }

    @Override
    public StringTree updateRefs(IRefFunction func) {
        BlobTree bt2 = this.data.updateRefs(func);
        if (bt2 == this.data) {
            return this;
        }
        return new StringTree(bt2);
    }

    @Override
    public StringTree toCanonical() {
        return this;
    }

    @Override
    public byte byteAt(long i) {
        if (i < 0L || i >= this.length) {
            return -1;
        }
        return this.data.byteAt(i);
    }

    @Override
    public int compareTo(AString o) {
        return this.data.compareTo(o.toBlob());
    }

    @Override
    public int charAt(long i) {
        throw new TODOException();
    }

    @Override
    public BlobTree toBlob() {
        return this.data;
    }

    @Override
    protected void writeToBuffer(ByteBuffer bb) {
        this.data.writeToBuffer(bb);
    }
}

