/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Strings;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class StringShort
extends AString {
    public static final int MAX_EMBEDDED_STRING_LENGTH = 137;
    public static final int MAX_LENGTH = 4096;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCLength(4096L) + 4096;
    private final Blob data;

    protected StringShort(Blob data) {
        super(data.length);
        this.data = data;
    }

    protected StringShort(byte[] data) {
        super(data.length);
        this.data = Blob.wrap(data);
    }

    protected StringShort(byte[] data, int offset, int length) {
        super(length);
        this.data = Blob.wrap(data, offset, length);
    }

    public static StringShort create(String string) {
        byte[] bs = string.getBytes(StandardCharsets.UTF_8);
        return new StringShort(bs);
    }

    public static StringShort create(AArrayBlob b) {
        if (b.count() == 0L) {
            return Strings.EMPTY;
        }
        return new StringShort(b.toFlatBlob());
    }

    @Override
    public int charAt(long index) {
        byte b = this.byteAt(index);
        if (b >= 0) {
            return b;
        }
        return -1;
    }

    @Override
    public byte byteAt(long index) {
        if (index < 0L || index >= this.length) {
            return -1;
        }
        return this.data.byteAt(index);
    }

    @Override
    public StringShort subSequence(long start, long end) {
        return new StringShort(this.data.slice(start, end - start));
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length > 4096L) {
            throw new InvalidDataException("StringShort too long: " + this.length, this);
        }
        if (this.length != (long)this.data.length) {
            throw new InvalidDataException("Wrong String length!", this);
        }
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.data.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRawData(byte[] bs, int pos) {
        return this.data.encodeRawData(bs, pos);
    }

    @Override
    public int estimatedEncodingSize() {
        return 3 + (int)this.length;
    }

    @Override
    public boolean isCanonical() {
        return this.length <= 4096L;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return this.length <= 137L;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    public static AString read(long length, ByteBuffer bb) {
        byte[] data = new byte[Utils.checkedInt(length)];
        bb.get(data);
        return new StringShort(data);
    }

    @Override
    public Blob toBlob() {
        return this.data;
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof StringShort) {
            return this.equals((StringShort)a);
        }
        return false;
    }

    public boolean equals(StringShort a) {
        return this.data.equals(a.data);
    }

    @Override
    public int compareTo(AString o) {
        return this.data.compareTo(o.toBlob());
    }

    @Override
    public ACell toCanonical() {
        if (this.length <= 4096L) {
            return this;
        }
        return Strings.create(this.data.toCanonical());
    }

    @Override
    protected void writeToBuffer(ByteBuffer bb) {
        this.data.writeToBuffer(bb);
    }
}

