/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.StringSlice;
import convex.core.data.Strings;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Bits;
import java.nio.ByteBuffer;

public class StringTree
extends AString {
    public static final int MINIMUM_LENGTH = 1025;
    public static final int BASE_SHIFT = 10;
    public static final int BIT_SHIFT_PER_LEVEL = 4;
    public static final int FANOUT = 16;
    public static final int MAX_ENCODING_LENGTH = 646;
    private final Ref<AString>[] children;
    private final int shift;

    protected StringTree(int length, Ref<AString>[] children) {
        super(length);
        this.children = children;
        this.shift = StringTree.calcShift(length);
    }

    protected static int calcShift(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Illegal length: " + length);
        }
        int bitCount = 32 - Bits.leadingZeros(length - 1) - 1;
        int shift = 10 + Math.floorDiv(bitCount - 10, 4) * 4;
        if (shift < 10) {
            throw new IllegalArgumentException("Too small: " + length);
        }
        return shift;
    }

    private final int childSize() {
        return 1 << this.shift;
    }

    public static StringTree create(String s) {
        int len = s.length();
        if (len < 1025) {
            throw new IllegalArgumentException("String too short for StringTree");
        }
        int shift = StringTree.calcShift(len);
        int childSize = 1 << shift;
        int n = StringTree.calcChildCount(len, shift);
        Ref[] children = new Ref[n];
        for (int i = 0; i < n; ++i) {
            Ref ref;
            int start = i * childSize;
            AString child = Strings.create(s.substring(start, Math.min(len, start + childSize)));
            children[i] = ref = child.getRef();
        }
        return new StringTree(len, children);
    }

    private int childIndexAt(int index) {
        int ci = index >> this.shift;
        return ci;
    }

    @Override
    public char charAt(int index) {
        int ci = index >> this.shift;
        int cix = index - ci * this.childSize();
        return this.children[ci].getValue().charAt(cix);
    }

    @Override
    public AString subSequence(int start, int end) {
        return StringSlice.create(this, start, end - start);
    }

    @Override
    public void validateCell() throws InvalidDataException {
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.length);
        int n = this.children.length;
        for (int i = 0; i < n; ++i) {
            pos = this.children[i].encode(bs, pos);
        }
        return pos;
    }

    public static StringTree read(int length, ByteBuffer bb) throws BadFormatException {
        int shift = StringTree.calcShift(length);
        int n = StringTree.calcChildCount(length, shift);
        Ref[] children = new Ref[n];
        for (int i = 0; i < n; ++i) {
            Ref ref;
            children[i] = ref = Format.readRef(bb);
        }
        return new StringTree(length, children);
    }

    protected static int calcChildCount(int length, int shift) {
        return (length - 1 >> shift) + 1;
    }

    @Override
    public int estimatedEncodingSize() {
        return 10 + 33 * this.children.length;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int getRefCount() {
        return this.children.length;
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int ic = this.children.length;
        if (i < 0) {
            throw new IndexOutOfBoundsException("Negative Ref index: " + i);
        }
        if (i < ic) {
            return this.children[i];
        }
        throw new IndexOutOfBoundsException("Ref index out of range: " + i);
    }

    @Override
    public StringTree updateRefs(IRefFunction func) {
        int ic = this.children.length;
        Ref<AString>[] newChildren = this.children;
        for (int i = 0; i < ic; ++i) {
            Ref<AString> current = this.children[i];
            Ref<?> newChild = func.apply(current);
            if (newChild == current) continue;
            if (this.children == newChildren) {
                newChildren = (Ref[])this.children.clone();
            }
            newChildren[i] = newChild;
        }
        if (newChildren == this.children) {
            return this;
        }
        return new StringTree(this.length, newChildren);
    }

    @Override
    protected void appendToStringBuffer(StringBuilder sb, int start, int length) {
        int cstart = this.childIndexAt(start);
        int cend = this.childIndexAt(start + length - 1);
        int csize = this.childSize();
        for (int i = cstart; i <= cend; ++i) {
            AString child = this.children[i].getValue();
            int c0 = Math.max(0, start - i * csize);
            int c1 = Math.min(child.length, start + length - i * csize);
            child.appendToStringBuffer(sb, c0, c1 - c0);
        }
    }

    @Override
    protected AString append(char charValue) {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuffer(sb, 0, this.length);
        sb.append(charValue);
        return Strings.create(sb.toString());
    }

    @Override
    public StringTree toCanonical() {
        return this;
    }
}

