/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.Format;
import convex.core.data.StringTree;
import convex.core.data.Strings;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class StringShort
extends AString {
    public static final int MAX_EMBEDDED_STRING_LENGTH = 68;
    public static final int MAX_LENGTH = 1024;
    public static final int MAX_ENCODING_LENGTH = 1 + Format.getVLCLength(1024L) + 2048;
    private String data;

    protected StringShort(String data) {
        super(data.length());
        this.data = data;
    }

    public static StringShort create(String string) {
        int len = string.length();
        if (len < 0 || len > 1024) {
            return null;
        }
        return new StringShort(string);
    }

    @Override
    public char charAt(int index) {
        return this.data.charAt(index);
    }

    @Override
    public StringShort subSequence(int start, int end) {
        if (start < 0 || end > this.length) {
            throw new IndexOutOfBoundsException("Out of range subSerqnce " + start + "," + end);
        }
        if (end < start) {
            throw new IllegalArgumentException("End before start!");
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        return new StringShort(this.data.substring(start, end));
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length > 1024) {
            throw new InvalidDataException("StringShort too long: " + this.length, this);
        }
        if (this.length != this.data.length()) {
            throw new InvalidDataException("Wrong String length!", this);
        }
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = Format.writeVLCLong(bs, pos, this.length);
        int n = this.data.length();
        for (int i = 0; i < n; ++i) {
            pos = Utils.writeChar(bs, pos, this.data.charAt(i));
        }
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 3 + this.length * 2;
    }

    @Override
    public boolean isCanonical() {
        return this.length <= 1024;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public boolean isEmbedded() {
        return this.length <= 68;
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    public static AString read(int length, ByteBuffer bb) {
        CharBuffer cb = bb.asCharBuffer();
        cb.limit(length);
        String data = cb.toString();
        bb.position(bb.position() + length * 2);
        return new StringShort(data);
    }

    @Override
    public String toString() {
        return this.data;
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public boolean equals(ACell a) {
        if (a instanceof StringShort) {
            return this.equals((StringShort)a);
        }
        return false;
    }

    public boolean equals(StringShort a) {
        return this.data.equals(a.data);
    }

    @Override
    public int compareTo(AString o) {
        return this.data.compareTo(o.toString());
    }

    @Override
    protected void appendToStringBuffer(StringBuilder sb, int start, int length) {
        sb.append(this.data.substring(start, start + length));
    }

    @Override
    protected AString append(char charValue) {
        StringBuilder sb = new StringBuilder(this.data);
        sb.append(charValue);
        return Strings.create(sb.toString());
    }

    @Override
    public ACell toCanonical() {
        if (this.length <= 1024) {
            return this;
        }
        return StringTree.create(this.data);
    }
}

