/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.InsecureRandom;
import convex.core.crypto.Providers;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.util.Utils;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;

public class Ed25519KeyPair
extends AKeyPair {
    private static final int SECRET_LENGTH = 64;
    private static final int SEED_LENGTH = 32;
    private final AccountKey publicKey;
    private KeyPair keyPair = null;
    private final Blob seed;
    private final byte[] secretKeyBytes;
    private static final String ED25519 = "Ed25519";

    private Ed25519KeyPair(AccountKey pk, Blob seed, byte[] skBytes) {
        this.publicKey = pk;
        this.seed = seed;
        this.secretKeyBytes = skBytes;
    }

    public static Ed25519KeyPair create(Blob seed) {
        if (seed.count() != 32L) {
            throw new IllegalArgumentException("256 bit private key material expected as seed!");
        }
        byte[] secretKeyBytes = new byte[64];
        byte[] pkBytes = new byte[32];
        Providers.SODIUM_SIGN.cryptoSignSeedKeypair(pkBytes, secretKeyBytes, seed.getBytes());
        AccountKey publicKey = AccountKey.wrap(pkBytes);
        return new Ed25519KeyPair(publicKey, seed, secretKeyBytes);
    }

    public static Ed25519KeyPair generate() {
        return Ed25519KeyPair.generate(new SecureRandom());
    }

    protected static Ed25519KeyPair create(KeyPair keyPair) {
        Blob seed = Ed25519KeyPair.extractSeed(keyPair.getPrivate());
        return Ed25519KeyPair.create(seed);
    }

    private static Blob extractSeed(PrivateKey private1) {
        byte[] data = private1.getEncoded();
        int n = data.length;
        Blob seed = Blob.wrap(data, n - 32, 32);
        return seed;
    }

    public static Ed25519KeyPair create(PublicKey publicKey, PrivateKey privateKey) {
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return Ed25519KeyPair.create(keyPair);
    }

    public static Ed25519KeyPair create(AccountKey accountKey, Blob encodedPrivateKey) {
        PublicKey publicKey = Ed25519KeyPair.publicKeyFromBytes(accountKey.getBytes());
        PrivateKey privateKey = Ed25519KeyPair.privateKeyFromBlob(encodedPrivateKey);
        return Ed25519KeyPair.create(publicKey, privateKey);
    }

    public Blob getSeed() {
        return this.seed;
    }

    public static Ed25519KeyPair generate(SecureRandom random) {
        Blob seed = Blob.createRandom(random, 32L);
        return Ed25519KeyPair.create(seed);
    }

    public static Ed25519KeyPair createSeeded(long seed) {
        InsecureRandom r = new InsecureRandom(seed);
        Blob seedBlob = Blob.createRandom(r, 32L);
        return Ed25519KeyPair.create(seedBlob);
    }

    public static Ed25519KeyPair create(byte[] keyMaterial) {
        return Ed25519KeyPair.create(Blob.create(keyMaterial));
    }

    public static Ed25519KeyPair create(PrivateKey privateKey) {
        Ed25519PrivateKeyParameters privateKeyParam = new Ed25519PrivateKeyParameters(privateKey.getEncoded(), 16);
        Ed25519PublicKeyParameters publicKeyParam = privateKeyParam.generatePublicKey();
        PublicKey generatedPublicKey = Ed25519KeyPair.publicKeyFromBytes(publicKeyParam.getEncoded());
        return Ed25519KeyPair.create(generatedPublicKey, privateKey);
    }

    static AccountKey extractAccountKey(PublicKey publicKey) {
        byte[] bytes = publicKey.getEncoded();
        int n = bytes.length;
        return AccountKey.wrap(bytes, n - 32);
    }

    static PrivateKey privateFromBytes(byte[] privKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(privKey));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey result = keyFactory.generatePrivate(pkcs8KeySpec);
            return result;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    @Override
    public Blob getEncodedPrivateKey() {
        return Ed25519KeyPair.extractPrivateKey(this.getPrivate());
    }

    static Blob extractPrivateKey(PrivateKey privateKey) {
        byte[] bytes = privateKey.getEncoded();
        return Blob.wrap(bytes);
    }

    public byte[] getPublicKeyBytes() {
        return this.getAccountKey().getBytes();
    }

    private static PrivateKey privateKeyFromBlob(Blob encodedKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(encodedKey.getBytes());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static PrivateKey privateKeyFromBytes(byte[] key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            PrivateKeyInfo privKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), (ASN1Encodable)new DEROctetString(key));
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privKeyInfo.getEncoded());
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return privateKey;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static PublicKey publicKeyFromBytes(byte[] key) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ED25519);
            SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(pubKeyInfo.getEncoded());
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            return publicKey;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new Error(e);
        }
    }

    @Override
    public PublicKey getPublic() {
        return this.getJCAKeyPair().getPublic();
    }

    @Override
    public KeyPair getJCAKeyPair() {
        if (this.keyPair == null) {
            PublicKey pub = Ed25519KeyPair.publicKeyFromBytes(this.publicKey.getBytes());
            PrivateKey priv = Ed25519KeyPair.privateKeyFromBytes(this.seed.getBytes());
            this.keyPair = new KeyPair(pub, priv);
        }
        return this.keyPair;
    }

    @Override
    public PrivateKey getPrivate() {
        return this.getJCAKeyPair().getPrivate();
    }

    @Override
    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    @Override
    public <R extends ACell> SignedData<R> signData(R value) {
        return SignedData.create(this, value);
    }

    @Override
    public ASignature sign(Hash hash) {
        byte[] signature = new byte[64];
        if (Providers.SODIUM_SIGN.cryptoSignDetached(signature, hash.getBytes(), 32L, this.getSecretKeyBytes())) {
            return Ed25519Signature.wrap(signature);
        }
        throw new Error("Signing failed!");
    }

    byte[] getSecretKeyBytes() {
        return this.secretKeyBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Ed25519KeyPair)) {
            return false;
        }
        return this.equals((Ed25519KeyPair)o);
    }

    boolean equals(Ed25519KeyPair other) {
        if (!this.seed.equals(other.seed)) {
            return false;
        }
        return this.publicKey.equals(other.publicKey);
    }
}

