/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.Reader;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;

public class Invoke
extends ATransaction {
    protected final ACell command;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.COMMAND};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);
    private static final long FORMAT_COUNT = FORMAT.count();

    protected Invoke(Address address, long sequence, ACell args) {
        super(FORMAT_COUNT, address, sequence);
        this.command = args;
    }

    public static Invoke create(Address address, long sequence, ACell command) {
        return new Invoke(address, sequence, command);
    }

    public static Invoke create(Address address, long sequence, String command) {
        return Invoke.create(address, sequence, Reader.read(command));
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -48;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = Format.write(bs, pos, this.command);
        return pos;
    }

    public Object getCommand() {
        return this.command;
    }

    public static Invoke read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        long aval = Format.readVLCLong(b, epos);
        Address address = Address.create(aval);
        long sequence = Format.readVLCLong(b, epos += Format.getVLCLength(aval));
        Object args = Format.read(b, epos += Format.getVLCLength(sequence));
        Invoke result = Invoke.create(address, sequence, args);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(args)));
        return result;
    }

    @Override
    public Context apply(Context context) {
        Context ctx = context;
        ctx = this.command instanceof AOp ? ctx.run((AOp)this.command) : ctx.run(this.command);
        return ctx;
    }

    @Override
    public int estimatedEncodingSize() {
        return 163;
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.command instanceof AOp) {
            ((AOp)this.command).validateCell();
        } else if (!Format.isCanonical(this.command)) {
            throw new InvalidDataException("Non-canonical object as command?", this);
        }
    }

    @Override
    public int getRefCount() {
        return Utils.refCount(this.command);
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        return Utils.getRef(this.command, i);
    }

    @Override
    public Invoke updateRefs(IRefFunction func) {
        ACell newCommand = Utils.updateRefs(this.command, func);
        if (newCommand == this.command) {
            return this;
        }
        return Invoke.create(this.origin, this.getSequence(), newCommand);
    }

    @Override
    public Invoke withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Invoke.create(this.origin, newSequence, this.command);
    }

    @Override
    public Invoke withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Invoke.create(newAddress, this.sequence, this.command);
    }

    @Override
    public byte getTag() {
        return -48;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.COMMAND.equals(key)) {
            return this.command;
        }
        if (Keywords.ORIGIN.equals(key)) {
            return this.origin;
        }
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

