/*
 * Decompiled with CFR 0.152.
 */
package convex.core.transactions;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Ref;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.Context;
import convex.core.lang.impl.RecordFormat;
import convex.core.transactions.ATransaction;

public class Call
extends ATransaction {
    protected final Address target;
    protected final long offer;
    protected final Symbol functionName;
    protected final AVector<ACell> args;
    private static final Keyword[] KEYS = new Keyword[]{Keywords.ORIGIN, Keywords.SEQUENCE, Keywords.TARGET, Keywords.OFFER, Keywords.CALL};
    private static final RecordFormat FORMAT = RecordFormat.of(KEYS);

    protected Call(Address address, long sequence, Address target, long offer, Symbol functionName, AVector<ACell> args) {
        super(FORMAT.count(), address, sequence);
        this.target = target;
        this.functionName = functionName;
        this.offer = offer;
        this.args = args;
    }

    public static Call create(Address address, long sequence, Address target, long offer, Symbol functionName, AVector<ACell> args) {
        return new Call(address, sequence, target, offer, functionName, args);
    }

    public static Call create(Address address, long sequence, Address target, Symbol functionName, AVector<ACell> args) {
        return Call.create(address, sequence, target, 0L, functionName, args);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -46;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = super.encodeRaw(bs, pos);
        pos = Format.write(bs, pos, this.target);
        pos = Format.writeVLCLong(bs, pos, this.offer);
        pos = Format.write(bs, pos, this.functionName);
        pos = Format.write(bs, pos, this.args);
        return pos;
    }

    public static Call read(Blob b, int pos) throws BadFormatException {
        int epos = pos + 1;
        long aval = Format.readVLCLong(b, epos);
        Address origin = Address.create(aval);
        long sequence = Format.readVLCLong(b, epos += Format.getVLCLength(aval));
        Address target = (Address)Format.read(b, epos += Format.getVLCLength(sequence));
        long offer = Format.readVLCLong(b, epos += Format.getEncodingLength(target));
        Symbol functionName = (Symbol)Format.read(b, epos += Format.getVLCLength(offer));
        AVector args = (AVector)Format.read(b, epos += Format.getEncodingLength(functionName));
        Call result = Call.create(origin, sequence, target, offer, functionName, args);
        result.attachEncoding(b.slice(pos, epos += Format.getEncodingLength(args)));
        return result;
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public Context apply(Context ctx) {
        return ctx.actorCall((ACell)this.target, this.offer, this.functionName, this.args.toCellArray());
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.target.validateCell();
    }

    @Override
    public int getRefCount() {
        return this.args.getRefCount();
    }

    public <T extends ACell> Ref<T> getRef(int i) {
        return this.args.getRef(i);
    }

    @Override
    public Call updateRefs(IRefFunction func) {
        ACell newArgs = this.args.updateRefs(func);
        if (this.args == newArgs) {
            return this;
        }
        return new Call(this.origin, this.sequence, this.target, this.offer, this.functionName, (AVector<ACell>)newArgs);
    }

    @Override
    public Call withSequence(long newSequence) {
        if (newSequence == this.sequence) {
            return this;
        }
        return Call.create(this.origin, newSequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public Call withOrigin(Address newAddress) {
        if (newAddress == this.origin) {
            return this;
        }
        return Call.create(newAddress, this.sequence, this.target, this.offer, this.functionName, this.args);
    }

    @Override
    public byte getTag() {
        return -46;
    }

    @Override
    public ACell get(Keyword key) {
        if (Keywords.CALL.equals(key)) {
            return this.args.cons(this.functionName);
        }
        if (Keywords.OFFER.equals(key)) {
            return CVMLong.create(this.offer);
        }
        if (Keywords.ORIGIN.equals(key)) {
            return this.origin;
        }
        if (Keywords.SEQUENCE.equals(key)) {
            return CVMLong.create(this.sequence);
        }
        if (Keywords.TARGET.equals(key)) {
            return this.target;
        }
        return null;
    }

    @Override
    public RecordFormat getFormat() {
        return FORMAT;
    }
}

