/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.RefSoft;

public final class BlobCache {
    private Ref<?>[] cache;
    private int size;

    private BlobCache(int size) {
        this.size = size;
        this.cache = new Ref[size];
    }

    public static BlobCache create(int size) {
        return new BlobCache(size);
    }

    int getSize() {
        return this.size;
    }

    public Ref<?> getCell(Hash hash) {
        int ix = this.calcIndex(hash);
        Ref<?> ref = this.cache[ix];
        if (ref == null) {
            return null;
        }
        if (ref instanceof RefSoft && !((RefSoft)ref).hasReference()) {
            this.cache[ix] = null;
            return null;
        }
        if (ref.getHash().equals(hash)) {
            return ref;
        }
        return null;
    }

    public void putCell(ACell cell) {
        Ref<ACell> ref = Ref.get(cell);
        this.putCell(ref);
    }

    public void putCell(Ref<?> ref) {
        int ix = this.calcIndex(ref.getHash());
        this.cache[ix] = ref;
    }

    private int calcIndex(Hash h) {
        int hash = (int)h.longValue();
        int ix = Math.floorMod(hash, this.size);
        return ix;
    }
}

