/*
 * Decompiled with CFR 0.152.
 */
package convex.core.store;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.store.BlobCache;
import convex.core.store.Stores;
import java.io.IOException;
import java.util.function.Consumer;

public abstract class AStore {
    protected final BlobCache blobCache = BlobCache.create(10000);

    public abstract <T extends ACell> Ref<T> storeRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3);

    public abstract <T extends ACell> Ref<T> storeTopRef(Ref<T> var1, int var2, Consumer<Ref<ACell>> var3);

    public abstract <T extends ACell> Ref<T> refForHash(Hash var1);

    public abstract Hash getRootHash() throws IOException;

    public <T extends ACell> T getRootData() throws IOException {
        Ref<T> ref = this.getRootRef();
        if (ref == null) {
            throw new MissingDataException(this, this.getRootHash());
        }
        return ref.getValue();
    }

    public <T extends ACell> Ref<T> getRootRef() throws IOException {
        Hash h = this.getRootHash();
        Ref<T> ref = this.refForHash(h);
        return ref;
    }

    public abstract <T extends ACell> Ref<T> setRootData(T var1) throws IOException;

    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACell decode(Blob encoding) throws BadFormatException {
        Object decoded;
        Hash hash = encoding.getContentHash();
        Ref<?> cached = this.blobCache.getCell(hash);
        if (cached != null) {
            return cached.getValue();
        }
        AStore tempStore = Stores.current();
        if (tempStore == this) {
            decoded = Format.read(encoding);
        } else {
            try {
                Stores.setCurrent(this);
                decoded = Format.read(encoding);
            }
            finally {
                Stores.setCurrent(tempStore);
            }
        }
        return decoded;
    }

    public abstract <T extends ACell> Ref<T> checkCache(Hash var1);
}

