/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import java.nio.ByteBuffer;
import java.util.WeakHashMap;

public final class Symbol
extends ASymbolic
implements Comparable<Symbol> {
    protected static final WeakHashMap<AString, Symbol> cache = new WeakHashMap(100);

    private Symbol(StringShort name) {
        super(name);
    }

    @Override
    public AType getType() {
        return Types.SYMBOL;
    }

    public static Symbol create(String name) {
        if (name == null) {
            return null;
        }
        return Symbol.create(Strings.create(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Symbol create(AString name) {
        if (!Symbol.validateName(name)) {
            return null;
        }
        Symbol sym = new Symbol((StringShort)name);
        WeakHashMap<AString, Symbol> weakHashMap = cache;
        synchronized (weakHashMap) {
            Symbol cached = cache.get(name);
            if (cached != null) {
                return cached;
            }
            cache.put(name, sym);
        }
        return sym;
    }

    public static Symbol unsafeCreate(String rawName) {
        return Symbol.unsafeCreate((StringShort)Strings.create(rawName));
    }

    public static Symbol unsafeCreate(StringShort rawName) {
        return new Symbol(rawName);
    }

    @Override
    public boolean equals(ACell o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Symbol) {
            return this.equals((Symbol)o);
        }
        return false;
    }

    public boolean equals(Symbol sym) {
        if (sym == this) {
            return true;
        }
        return sym.name.equals(this.name);
    }

    @Override
    public int compareTo(Symbol sym) {
        return this.name.compareTo(sym.name);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 50;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = (byte)this.name.count();
        return this.name.writeRawData(bs, pos);
    }

    public static Symbol read(ByteBuffer bb) throws BadFormatException {
        int len = 0xFF & bb.get();
        AString name = Format.readUTF8String(bb, len);
        Symbol sym = Symbol.create(name);
        if (sym == null) {
            throw new BadFormatException("Can't read symbol");
        }
        return sym;
    }

    public static Symbol read(Blob blob, int offset) throws BadFormatException {
        int len = 0xFF & blob.byteAt(offset + 1);
        AString name = Format.readUTF8String(blob, offset + 2, len);
        Symbol sym = Symbol.create(name);
        if (sym == null) {
            throw new BadFormatException("Can't read symbol");
        }
        if (sym.cachedEncoding() == null) {
            if (blob.byteAt(offset) == 50) {
                // empty if block
            }
            sym.attachEncoding(blob.slice(offset, offset + 2 + len));
        }
        return sym;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(this.getName());
        return bb.check(limit);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!Symbol.validateName(this.name)) {
            throw new InvalidDataException("Invalid Symbol name: " + this.name, this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public byte getTag() {
        return 50;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public AString toCVMString(long limit) {
        return this.name;
    }
}

